package cn.quant.baa.pay.rest;

import cn.quant.baa.pay.model.AssertUtils;
import cn.quant.spring.IllegalParameterException;
import cn.quant.spring.NullException;
import cn.quant.spring.context.ContextLoader;
import cn.quant.spring.context.ServerApplicationContext;
import cn.quant.spring.rest.AbstractController;
import org.springframework.beans.factory.annotation.Autowired;

import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import java.util.Set;

import static cn.quant.baa.pay.dict.MessageEnum.EMPTY_REQ_DATA;

/**
 * Created by Administrator on 2021/8/28 0028.
 */
public abstract class BusinessController extends AbstractController {

    @Autowired
    private Validator validator;

    public <T> void validate(T t) {

        if (t == null) {
            throw new NullException();
        }

        Set<ConstraintViolation<T>> validate = validator.validate(t);
        if (validate.size() > 0) {
            ConstraintViolation<T> next = validate.iterator().next();
            String s = next.getPropertyPath().toString();
            String template = next.getMessageTemplate();
            ServerApplicationContext applicationContext = ContextLoader.getCurrentApplicationContext();
            String message = applicationContext.getMessage(template, "{0}-Illegal request parameter", (Object) s);
            throw new IllegalParameterException(message);
        }
    }
}
