package cn.quant.baa.pay.service;

import cn.quant.baa.pay.component.Sequencer;
import cn.quant.baa.pay.context.TransactionSession;
import cn.quant.baa.pay.dict.AcctTypeId;
import cn.quant.baa.pay.dict.CurrencyCode;
import cn.quant.baa.pay.dict.StatusCode;
import cn.quant.baa.pay.jpa.entity.AccountEntity;
import cn.quant.baa.pay.jpa.entity.AccountIds;
import cn.quant.baa.pay.jpa.entity.EntityBuilder;
import cn.quant.baa.pay.jpa.repository.AccountRepository;
import cn.quant.baa.pay.model.AssertUtils;
import cn.quant.spring.NullException;
import cn.quant.spring.util.DateUtils;
import cn.quant.spring.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;

import static cn.quant.baa.pay.Constant.MINI_LOCAL_DATE;
import static cn.quant.baa.pay.dict.MessageEnum.*;

/**
 * Created by Administrator on 2021/8/25 0025.
 */
public abstract class BusinessService {

    private static final Logger logger = LoggerFactory.getLogger(BusinessService.class);


    public TransactionSession prepare(String institutionId, String productId, String buyerId, TransactionSession session) {

        if (session == null) {
            throw new NullException("Session is null.");
        }

        AccountIds ids = new AccountIds();
        ids.setInstitutionId(institutionId);
        ids.setAccountRefNo(buyerId);
        AccountEntity account = session.findOne(AccountEntity.class, ids);
        if (account == null) {
            Long id = session.nextId(buyerId.hashCode());
            account = EntityBuilder.account(ids, productId, id, buyerId, session.partitionKey(id));
            session.pushEntity(account);
        }

        session.setAccount(account);
        return session;
    }
}
