package cn.quant.baa.pay.model;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * Created by Administrator on 2021/8/24 0024.
 */
public class GoodsDetail implements Serializable{

    private static final long serialVersionUID = -353037200982963915L;

    /**
     * 商品ID
     */
    @Size(min = 6, max = 64)
    private String goodsId;

    /**
     * 商品名
     */
    private String goodsName;

    /**
     * 数量
     */
    private String quantity;

    /**
     * 商品单价
     */
    private String price;

    /**
     * 优惠金额
     */
    private String discounts;

    /**
     * 实付金额
     */
    private String amount;

    /**
     * 附加信息
     */
    private String attach;


    public String getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(String goodsId) {
        this.goodsId = goodsId;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public String getQuantity() {
        return quantity;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getDiscounts() {
        return discounts;
    }

    public void setDiscounts(String discounts) {
        this.discounts = discounts;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getAttach() {
        return attach;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("GoodsDetail{");
        sb.append("goodsId='").append(goodsId).append('\'');
        sb.append(", goodsName='").append(goodsName).append('\'');
        sb.append(", quantity=").append(quantity);
        sb.append(", price='").append(price).append('\'');
        sb.append(", discounts='").append(discounts).append('\'');
        sb.append(", amount='").append(amount).append('\'');
        sb.append(", attach='").append(attach).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
