package cn.quant.baa.pay.model.web;

import javax.validation.constraints.*;
import java.io.Serializable;

/**
 * Created by Administrator on 2021/8/24 0024.
 */
public class GoodsDetail implements Serializable{

    private static final long serialVersionUID = -353037200982963915L;

    /**
     * 商品ID
     */
    @NotNull(message = "ILLEGAL_REQ_GOODS_NO")
    @Size(min = 6, max = 64, message = "ILLEGAL_REQ_GOODS_NO")
    private String goodsNo;

    /**
     * 商品名
     */
    @NotNull(message = "ILLEGAL_REQ_GOODS_NAME")
    @Size(min = 3, max = 512, message = "ILLEGAL_REQ_GOODS_NAME")
    private String goodsName;

    /**
     * 数量
     */
    @NotNull(message = "ILLEGAL_REQ_GOODS_QUANTITY")
    @Max(value = 30000, message = "ILLEGAL_REQ_GOODS_QUANTITY")
    @Min(value = 1, message = "ILLEGAL_REQ_GOODS_QUANTITY")
    private String quantity;

    /**
     * 商品单价
     */
    @NotNull(message = "ILLEGAL_REQ_GOODS_PRICE")
    @DecimalMin(value = "0.00")
    private String price;

    /**
     * 优惠金额
     */
    @NotNull(message = "ILLEGAL_REQ_GOODS_DISC")
    @DecimalMin(value = "0.00")
    private String discounts;

    /**
     * 实付金额
     */
    @NotNull(message = "ILLEGAL_REQ_GOODS_AMT")
    @DecimalMin(value = "0.01")
    private String amount;

    /**
     * 附加信息
     */
    @Size(max = 512, message = "ILLEGAL_REQ_GOODS_ATTACH")
    private String attach;


    public String getGoodsNo() {
        return goodsNo;
    }

    public void setGoodsNo(String goodsNo) {
        this.goodsNo = goodsNo;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public String getQuantity() {
        return quantity;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getDiscounts() {
        return discounts;
    }

    public void setDiscounts(String discounts) {
        this.discounts = discounts;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getAttach() {
        return attach;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("GoodsDetail{");
        sb.append("goodsNo='").append(goodsNo).append('\'');
        sb.append(", goodsName='").append(goodsName).append('\'');
        sb.append(", quantity=").append(quantity);
        sb.append(", price='").append(price).append('\'');
        sb.append(", discounts='").append(discounts).append('\'');
        sb.append(", amount='").append(amount).append('\'');
        sb.append(", attach='").append(attach).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
