package cn.quant.baa.pay.jpa.entity;

import cn.quant.baa.pay.dict.AcctTypeId;
import cn.quant.baa.pay.dict.CurrencyCode;
import cn.quant.baa.pay.dict.StatusCode;
import cn.quant.spring.data.jpa.entity.DescribablePartitionEntity;
import org.hibernate.annotations.Type;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/25 0025.
 */
@Entity
@Table(name = "account")
public class AccountEntity extends DescribablePartitionEntity implements Serializable {

    private static final long serialVersionUID = 1878129316567080724L;
    @EmbeddedId
    private AccountIds ids;

    @Column(name = "ACCOUNT_ID", nullable = false, updatable = false)
    private Long accountId;

    @Column(name = "PRODUCT_ID", nullable = false, length = 4)
    private String productId;

    @Column(name = "PROTOCOL_RULE", nullable = true, length = 4)
    private String protocolRule;

    @Enumerated(value = EnumType.STRING)
    @Column(name = "ACCT_TYPE_ID", nullable = false, length = 4)
    private AcctTypeId acctTypeId;

    @Column(name = "CURRENT_CYCLE_NO", nullable = false)
    private Integer currentCycleNo;

    @Enumerated(EnumType.STRING)
    @Column(name = "CURRENCY_CODE", nullable = false, length = 3)
    private CurrencyCode currencyCode;

    @Column(name = "MANUAL_STATUS", nullable = true, length = 4)
    private String manualStatus;

    @Column(name = "MANUAL_STATUS_DATE", nullable = true)
    private LocalDate manualStatusDate;

    @Enumerated(EnumType.STRING)
    @Column(name = "AUTO_STATUS", nullable = false, length = 4)
    private StatusCode autoStatus;

    @Column(name = "AUTO_STATUS_DATE", nullable = false)
    private LocalDate autoStatusDate;

    @Column(name = "OPEN_DATE", nullable = false)
    private LocalDate openDate;

    @Type(type = "yes_no")
    @Column(name = "CORPOTATE_ACCT_FLAG", nullable = false, length = 1)
    private Boolean corpotateAcctFlag;

    @Column(name = "EXTERNAL_ACCT_NO", nullable = true, length = 32)
    private String externalAcctNo;

    @Type(type = "yes_no")
    @Column(name = "AUTO_PAYMENT_FLAG", nullable = false, length = 1)
    private Boolean autoPaymentFlag;

    @Column(name = "AUTO_PAYMENT_WARN_DATE", nullable = false)
    private LocalDate autoPaymentWarnDate;

    @Column(name = "TXN_NO", nullable = false)
    private Integer txnNo;

    @Column(name = "NEXT_TXN_NO", nullable = false)
    private Integer nextTxnNo;

    @Column(name = "TOTAL_CREDIT", nullable = false, precision = 2)
    private BigDecimal totalCredit;

    @Column(name = "TOTAL_DEBIT", nullable = false, precision = 2)
    private BigDecimal totalDebit;

    @Column(name = "CREDIT_TXN_COUNT", nullable = false)
    private Integer creditTxnCount;

    @Column(name = "DEBIT_TXT_COUNT", nullable = false)
    private Integer debitTxtCount;

    public AccountIds getIds() {
        return ids;
    }

    public void setIds(AccountIds ids) {
        this.ids = ids;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProtocolRule() {
        return protocolRule;
    }

    public void setProtocolRule(String protocolRule) {
        this.protocolRule = protocolRule;
    }

    public AcctTypeId getAcctTypeId() {
        return acctTypeId;
    }

    public void setAcctTypeId(AcctTypeId actTypeId) {
        this.acctTypeId = actTypeId;
    }

    public Integer getCurrentCycleNo() {
        return currentCycleNo;
    }

    public void setCurrentCycleNo(Integer currentCycleNo) {
        this.currentCycleNo = currentCycleNo;
    }

    public CurrencyCode getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getManualStatus() {
        return manualStatus;
    }

    public void setManualStatus(String manualStatus) {
        this.manualStatus = manualStatus;
    }

    public LocalDate getManualStatusDate() {
        return manualStatusDate;
    }

    public void setManualStatusDate(LocalDate manualStatusDate) {
        this.manualStatusDate = manualStatusDate;
    }

    public StatusCode getAutoStatus() {
        return autoStatus;
    }

    public void setAutoStatus(StatusCode autoStatus) {
        this.autoStatus = autoStatus;
    }

    public LocalDate getAutoStatusDate() {
        return autoStatusDate;
    }

    public void setAutoStatusDate(LocalDate autoStatusDate) {
        this.autoStatusDate = autoStatusDate;
    }

    public LocalDate getOpenDate() {
        return openDate;
    }

    public void setOpenDate(LocalDate openDate) {
        this.openDate = openDate;
    }

    public Boolean getCorpotateAcctFlag() {
        return corpotateAcctFlag;
    }

    public void setCorpotateAcctFlag(Boolean corpotateAcctFlag) {
        this.corpotateAcctFlag = corpotateAcctFlag;
    }

    public String getExternalAcctNo() {
        return externalAcctNo;
    }

    public void setExternalAcctNo(String externalAcctNo) {
        this.externalAcctNo = externalAcctNo;
    }

    public Boolean getAutoPaymentFlag() {
        return autoPaymentFlag;
    }

    public void setAutoPaymentFlag(Boolean autoPaymentFlag) {
        this.autoPaymentFlag = autoPaymentFlag;
    }

    public LocalDate getAutoPaymentWarnDate() {
        return autoPaymentWarnDate;
    }

    public void setAutoPaymentWarnDate(LocalDate autoPaymentWarnDate) {
        this.autoPaymentWarnDate = autoPaymentWarnDate;
    }

    public Integer getTxnNo() {
        return txnNo;
    }

    public void setTxnNo(Integer txnNo) {
        this.txnNo = txnNo;
    }

    public Integer getNextTxnNo() {
        return nextTxnNo;
    }

    public void setNextTxnNo(Integer nextTxnNo) {
        this.nextTxnNo = nextTxnNo;
    }

    public BigDecimal getTotalCredit() {
        return totalCredit;
    }

    public void setTotalCredit(BigDecimal totalCredit) {
        this.totalCredit = totalCredit;
    }

    public BigDecimal getTotalDebit() {
        return totalDebit;
    }

    public void setTotalDebit(BigDecimal totalDebit) {
        this.totalDebit = totalDebit;
    }

    public Integer getCreditTxnCount() {
        return creditTxnCount;
    }

    public void setCreditTxnCount(Integer creditTxnCount) {
        this.creditTxnCount = creditTxnCount;
    }

    public Integer getDebitTxtCount() {
        return debitTxtCount;
    }

    public void setDebitTxtCount(Integer debitTxtCount) {
        this.debitTxtCount = debitTxtCount;
    }

    @Override
    public String persistenceKey() {
        return ids.persistenceKey();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AccountEntity that = (AccountEntity) o;
        return Objects.equals(ids, that.ids);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("AccountEntity{");
        sb.append("ids=").append(ids);
        sb.append(", accountId=").append(accountId);
        sb.append(", productId='").append(productId).append('\'');
        sb.append(", protocolRule='").append(protocolRule).append('\'');
        sb.append(", acctTypeId=").append(acctTypeId);
        sb.append(", currentCycleNo=").append(currentCycleNo);
        sb.append(", currencyCode=").append(currencyCode);
        sb.append(", manualStatus='").append(manualStatus).append('\'');
        sb.append(", manualStatusDate=").append(manualStatusDate);
        sb.append(", autoStatus=").append(autoStatus);
        sb.append(", autoStatusDate=").append(autoStatusDate);
        sb.append(", openDate=").append(openDate);
        sb.append(", corpotateAcctFlag=").append(corpotateAcctFlag);
        sb.append(", externalAcctNo='").append(externalAcctNo).append('\'');
        sb.append(", autoPaymentFlag=").append(autoPaymentFlag);
        sb.append(", autoPaymentWarnDate=").append(autoPaymentWarnDate);
        sb.append(", txnNo=").append(txnNo);
        sb.append(", nextTxnNo=").append(nextTxnNo);
        sb.append(", totalCredit=").append(totalCredit);
        sb.append(", totalDebit=").append(totalDebit);
        sb.append(", creditTxnCount=").append(creditTxnCount);
        sb.append(", debitTxtCount=").append(debitTxtCount);
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}
