package cn.quant.baa.pay.service;

import cn.quant.baa.pay.context.TransactionSession;
import cn.quant.baa.pay.dict.StatusCode;
import cn.quant.baa.pay.jpa.entity.BatchCycleTriggerEntity;
import cn.quant.baa.pay.jpa.entity.TransactionSummaryEntity;
import cn.quant.baa.pay.jpa.repository.BatchCycleTriggerRepository;
import cn.quant.baa.pay.model.web.CallbackRequestData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by Administrator on 2021/8/24 0024.
 */
@Service
public class CallbackService extends BusinessService {

    private static final Logger logger = LoggerFactory.getLogger(TransactionService.class);

    @Transactional(propagation = Propagation.NOT_SUPPORTED)
    public void callback(CallbackRequestData request) throws Exception {
        update(request);
        System.currentTimeMillis();
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public void update(CallbackRequestData request) throws Exception {
        TransactionSession session = TransactionSession.session();

        Long orderNo = Long.valueOf(request.getOrderNo());
        String checkCode = request.getCheckCode();

//        session.getRepository();

        TransactionSummaryEntity summaryEntity = session.findOne(TransactionSummaryEntity.class, checkCode);
        if (summaryEntity == null) {
            throw new Exception("ERROR");
        }

        BatchCycleTriggerRepository repository = (BatchCycleTriggerRepository) session.getRepository(BatchCycleTriggerEntity.class);
        BatchCycleTriggerEntity triggerEntity = repository.findOne(summaryEntity.getTransactionId(), summaryEntity.getTxnType());
        if (triggerEntity == null) {
            throw new Exception("ERROR");
        }

        String tradeState = request.getTradeState();
        if (StatusCode.SUCC.name().equals(tradeState)) {

        } else {

        }
        new Integer(null);
    }

}
