package cn.quant.baa.pay.rest;

import cn.quant.baa.pay.acquirer.AcquirerProperties;
import cn.quant.baa.pay.acquirer.AcquirerPropertiesSource;
import cn.quant.baa.pay.annotation.BusinessMapping;
import cn.quant.baa.pay.config.DictionaryViewer;
import cn.quant.baa.pay.model.dto.DictionaryItemDTO;
import cn.quant.baa.pay.model.web.CallbackRequestData;
import cn.quant.baa.pay.service.CallbackService;
import cn.quant.spring.ProfileException;
import cn.quant.spring.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.Map;

import static cn.quant.baa.pay.Constant.*;

/**
 * Created by Administrator on 2021/9/26 0026.
 */
@RestController
@RequestMapping("/callback")
public class CallbackController extends BusinessController {

    private static final Logger logger = LoggerFactory.getLogger(TransactionController.class);

    @Autowired
    private AcquirerPropertiesSource acquirerPropertiesSource;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private CallbackService callbackService;

    @ResponseBody
    @BusinessMapping
    @PostMapping("/debug/merchant/pay")
    public ResponseEntity pay(@RequestParam("order_no") String orderNo, @RequestParam("status") String status) throws Exception {
        logger.info("Merchant pay callback : {}, {}", orderNo, status);
        return ResponseEntity.ok("ok");
    }

    @ResponseBody
    @BusinessMapping
    @PostMapping("/pay/wx/{chanId}/{acctId}/{orderNo}")
    public ResponseEntity pay(@PathVariable("chanId") String chanId, @PathVariable("acctId") String acctId
            , @PathVariable("orderNo") String orderNo
            , @RequestBody Map request) throws Exception {

        logger.info("Weixin pay callback : {}, {}, {}, {}", chanId, acctId, orderNo, request.toString());

        Long channelId = Long.parseLong(chanId, 16);
        Long accountId = Long.parseLong(acctId, 16);

        DictionaryItemDTO dict = DictionaryViewer.get(DICT_TYPE_PAY, DICT_CODE_WXP);
        if (dict == null) {
            throw new ProfileException("Configuration not found in dictionary : {}; {}; {}; {};", DICT_TYPE_PAY, DICT_CODE_WXP, channelId, request);
        }

        AcquirerProperties properties = acquirerPropertiesSource.get(channelId);
        if (properties == null || !dict.getCode().equals(properties.getPayChanCode())) {
            throw new ProfileException("Acquirer not found : {}; {}; {}; {};", DICT_TYPE_PAY, DICT_CODE_WXP, channelId, request);
        }

        CallbackRequestData requestData = new CallbackRequestData();
        requestData.setChanId(properties.getMchChanId());
        requestData.setAccountId(accountId);
        requestData.setOrderNo("75774627146563586");
        requestData.setChanTransactionId("1217752501201407033233368018");
        requestData.setCheckCode("3ffe82f6731f6e09255bc258d1131a75");
        //TODO:状态转码
        requestData.setTradeState("SUCC");
        requestData.setTradeStateDesc("支付成功");
        requestData.setSuccessTime(LocalDateTime.now());

        String redisKey = StringUtils.toDelimitedString(REDIS_NAMESPACE_PAY, properties.getInstitutionId(), properties.getProductId(), orderNo);


        callbackService.callback(requestData);
        return null;
    }
}
