package cn.quant.baa.pay.jpa.entity;

import cn.quant.spring.data.jpa.entity.EntityPrimaryIds;
import cn.quant.spring.util.StringUtils;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import java.io.Serializable;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/25 0025.
 */
@Embeddable
public class AccountIds extends EntityPrimaryIds implements Serializable {
    private static final long serialVersionUID = -3364378648694932295L;

    private final static String CLASS_NAME = AccountEntity.class.getSimpleName();

    @Column(name = "INSTITUTION_ID", nullable = false, updatable = false, length = 4)
    private String institutionId;

    @Column(name = "ACCOUNT_REF_NO", nullable = false, updatable = false, length = 32)
    private String accountRefNo;

    public String getInstitutionId() {
        return institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public String getAccountRefNo() {
        return accountRefNo;
    }

    public void setAccountRefNo(String accountRefNo) {
        this.accountRefNo = accountRefNo;
    }

    @Override
    public String persistenceKey() {
        return StringUtils.toDelimitedString(CLASS_NAME, institutionId, accountRefNo);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AccountIds that = (AccountIds) o;
        return Objects.equals(institutionId, that.institutionId) &&
                Objects.equals(accountRefNo, that.accountRefNo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(CLASS_NAME, institutionId, accountRefNo);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("AccountIds{");
        sb.append("institutionId='").append(institutionId).append('\'');
        sb.append(", accountRefNo='").append(accountRefNo).append('\'');
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}
