#! /bin/bash

CMD_PATH="$( dirname "$0" )"
cd "$CMD_PATH"

platform=`uname`
sys_bit=`uname -m`
echo $platform
echo $sys_bit

if [ $platform='Darwin' ]
then
	if [ $sys_bit='x86_64' ]
	then
   		swt_lib=./lib/org.eclipse.swt.cocoa.macosx.x86_64-4.3.jar
   	else
   		swt_lib=./lib/org.eclipse.swt.cocoa.macosx-4.3.jar
	fi
else
	if [ $sys_bit='x86_64' ]
	then
   		swt_lib=./lib/org.eclipse.swt.gtk.linux.x86_64-4.3.jar
   	else
   		swt_lib=./lib/org.eclipse.swt.gtk.linux.x86-4.3.jar
	fi
fi
echo $swt_lib

filename=`find . -name "yop-isv-tools-*.jar" | sort -r | head -1`
echo $filename

# 探测 java
jre_zip_filename="jre_sh.zip"
jre_dir_path="jre"
#if [[ -n $(type -p java) ]]; then
#  echo '本地安装，可直接执行'
#  java_cmd=java
#el
if [[ (-n "$JAVA_HOME") && (-x "$JAVA_HOME/bin/java") ]]; then
  echo '本地安装，环境变量'
  java_cmd="$JAVA_HOME/bin/java"
elif [[ -d "$jre_dir_path" ]]; then
  echo '本地有jre目录'
  java_cmd="$jre_dir_path/bin/java"
elif [[ -f "$jre_zip_filename" ]]; then
  echo '本地有jre压缩包，解压后执行'
  unzip -o -q $jre_zip_filename
  java_cmd="$jre_dir_path/bin/java"
else
   echo '下载并安装JRE环境...'
   curl -L "https://yopsdk.bj.bcebos.com/jre_sh.zip" -o $jre_zip_filename
   unzip $jre_zip_filename -d $jre_dir_path
   java_cmd="$jre_dir_path/bin/java"
fi
echo $java_cmd

$java_cmd -XstartOnFirstThread -Dfile.encoding=UTF-8 -cp $swt_lib:$filename com.yeepay.g3.yop.tools.support.RSAWindow