#! /bin/bash

CMD_PATH="$(dirname "$0")"
cd "$CMD_PATH"

platform=$(uname -m)
swt_lib=./lib/org.eclipse.swt.cocoa.macosx-4.3.jar
if [ $platform='x86_64' ] || [ $platform='arm64' ]
then
  swt_lib=./lib/org.eclipse.swt.cocoa.macosx.x86_64-4.3.jar
fi
swt_lib=$swt_lib:.$swt_lib
echo $swt_lib

filename=$(find . -name "yop-isv-tools-*.jar" | sort -r | head -1)
echo $filename

# 探测 java
jre_zip_filename="jre_mac.zip"
jre_dir_path="jre"
if [[ ("$(/usr/libexec/java_home | grep 'JavaVirtualMachines/jdk')" != "") && ("$(/usr/libexec/java_home | grep 'JavaAppletPlugin.plugin')" == "") ]]; then
  echo '本地已安装JRE'
  java_cmd=$(/usr/libexec/java_home | grep 'JavaVirtualMachines/jdk')/bin/java
elif [[ (-n "$JAVA_HOME") && (-x "$JAVA_HOME/bin/java") ]]; then
  echo '本地已安装JRE，环境变量'
  java_cmd="$JAVA_HOME/bin/java"
elif [[ -d "$jre_dir_path" ]]; then
  echo '本地有jre目录'
  java_cmd="$jre_dir_path/bin/java"
elif [[ -f "$jre_zip_filename" ]]; then
  echo '本地有jre压缩包，解压后执行'
  unzip -o -q $jre_zip_filename
  java_cmd="$jre_dir_path/bin/java"
else
   echo '下载并安装JRE环境...'
   curl -L "https://yopsdk.bj.bcebos.com/jre_mac.zip" -o $jre_zip_filename
   unzip $jre_zip_filename -d $jre_dir_path
   java_cmd="$jre_dir_path/bin/java"
fi
echo 'Java运行时：' $java_cmd

$java_cmd -XstartOnFirstThread -Dfile.encoding=UTF-8 -cp $swt_lib:$filename com.yeepay.g3.yop.tools.support.RSAWindow

# 运行完毕自动退出
#osascript -e 'tell application "Terminal" to quit' &
#exit
