package cn.quant.baa.pay.service;

import cn.quant.baa.pay.model.MerchantChannelRequestData;
import cn.quant.baa.pay.config.MerchantAcquirerBuilder;
import cn.quant.baa.pay.model.MerchantAcquirer;
import cn.quant.baa.pay.model.MerchantAcquirerBook;
import cn.quant.baa.pay.model.MerchantAcquirerProfile;
import cn.quant.baa.pay.model.ModelBuilder;
import cn.quant.spring.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.Map;

/**
 * Created by Administrator on 2021/8/23 0023.
 */
@Service
public class MerchantService {
    @Autowired
    private MerchantAcquirerBuilder merchantAcquirerBuilder;

    @Autowired
    private ModelBuilder modelBuilder;


    @Cacheable(cacheManager = "profileCacheManager"
            , cacheNames = "LOCAL_PROFILE"
            , key = "#requestData.persistenceKey()")
    public Map<String, MerchantAcquirerBook> getChannels(MerchantChannelRequestData requestData) {
        String mchId = requestData.getMchId();
        String channel = requestData.getChannel();
        Map<String, Collection<MerchantAcquirerProfile>> profiles;

        if (StringUtils.isEmpty(channel)) {
            profiles = merchantAcquirerBuilder.get(mchId);
        } else {
            profiles = merchantAcquirerBuilder.get(mchId, channel);
        }

        Map<String, MerchantAcquirerBook> response = modelBuilder.toModel(profiles);
        return response;
    }

    public MerchantAcquirer getChannel(MerchantChannelRequestData requestData) {
        return getChannel(Long.parseLong(requestData.getChanId()));
    }

    @Cacheable(cacheManager = "profileCacheManager"
            , cacheNames = "LOCAL_PROFILE"
            , key = "#id")
    public MerchantAcquirer getChannel(Long id) {
        MerchantAcquirerProfile profile = merchantAcquirerBuilder.get(id);
        return modelBuilder.toModel(profile);
    }
}
