package cn.quant.baa.pay.rest;

import cn.quant.baa.pay.annotation.BusinessMapping;
import cn.quant.baa.pay.model.BusinessRequest;
import cn.quant.baa.pay.model.GoodsDetail;
import cn.quant.baa.pay.model.PayRequestData;
import cn.quant.baa.pay.service.TransactionService;
import cn.quant.spring.rest.AbstractController;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.web.bind.annotation.*;

import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import java.util.Set;

/**
 * Created by Administrator on 2021/8/24 0024.
 */
@RestController
@RequestMapping("/transaction")
public class TransactionController extends BusinessController {

    @Autowired
    private TransactionService transactionService;

    @ResponseBody
    @BusinessMapping(session = 1)
    @PostMapping("/pay")
    public void pay(@RequestBody BusinessRequest<PayRequestData> request) {


        PayRequestData data = request.getData();


        transactionService.pay(data);


        System.currentTimeMillis();
    }
}
