package cn.quant.baa.pay.jpa.entity;

import cn.quant.baa.pay.dict.AccessType;
import cn.quant.spring.data.jpa.entity.DescriptionEntity;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/22 0022.
 */
@Entity
@Table(name = "pay_feature")
public class PayFeatureEntity extends DescriptionEntity implements Serializable {

    private static final long serialVersionUID = -3977191384143230391L;

    @EmbeddedId
    private PayFeatureIds ids;

    @Enumerated(value = EnumType.STRING)
    @Column(name = "ACCESS_TYPE", nullable = false, length = 3)
    private AccessType accessType;

    @Column(name = "ACCESS_METHOD", nullable = false, length = 255)
    private String accessMethod;

    @Column(name = "VERSION", nullable = false, length = 4)
    private String version;

    @Column(name = "PAY_ACCESS", nullable = false, length = 255)
    private String payAccess;

    @Column(name = "PRODUCT_CODE", nullable = false, length = 255)
    private String productCode;

    @Column(name = "REFUND_ACCESS", nullable = false, length = 255)
    private String refundAccess;

    @Column(name = "CHECK_ACCESS", nullable = false, length = 255)
    private String checkAccess;

    public PayFeatureIds getIds() {
        return ids;
    }

    public void setIds(PayFeatureIds ids) {
        this.ids = ids;
    }

    public AccessType getAccessType() {
        return accessType;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public String getAccessMethod() {
        return accessMethod;
    }

    public void setAccessMethod(String accessMethod) {
        this.accessMethod = accessMethod;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPayAccess() {
        return payAccess;
    }

    public void setPayAccess(String payAccess) {
        this.payAccess = payAccess;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getRefundAccess() {
        return refundAccess;
    }

    public void setRefundAccess(String refundAccess) {
        this.refundAccess = refundAccess;
    }

    public String getCheckAccess() {
        return checkAccess;
    }

    public void setCheckAccess(String checkAccess) {
        this.checkAccess = checkAccess;
    }

    @Override
    public String persistenceKey() {
        return ids.persistenceKey();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PayFeatureEntity that = (PayFeatureEntity) o;
        return Objects.equals(ids, that.ids);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("PayFeatureEntity{");
        sb.append("ids=").append(ids);
        sb.append(", accessType=").append(accessType);
        sb.append(", accessMethod='").append(accessMethod).append('\'');
        sb.append(", version='").append(version).append('\'');
        sb.append(", payAccess='").append(payAccess).append('\'');
        sb.append(", refundAccess='").append(refundAccess).append('\'');
        sb.append(", checkAccess='").append(checkAccess).append('\'');
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}
