package cn.quant.baa.pay.jpa.entity;

import cn.quant.spring.data.jpa.entity.EntityPrimaryIds;
import cn.quant.spring.util.StringUtils;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import java.io.Serializable;
import java.util.Objects;

/**
 * Created by Administrator on 2021/9/13 0013.
 */
@Embeddable
public class StatusCodeIds extends EntityPrimaryIds implements Serializable {

    public final static String CLASS_NAME = StatusCodeEntity.class.getSimpleName();
    private static final long serialVersionUID = 6497603433019425612L;

    @Column(name = "INSTITUTION_ID", nullable = false, updatable = false, length = 4)
    private String institutionId;

    @Column(name = "ENTITY", nullable = false, updatable = false, length = 4)
    private String entity;

    @Column(name = "CODE", nullable = false, updatable = false, length = 4)
    private String code;

    public String getInstitutionId() {
        return institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public String getEntity() {
        return entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getPersistentKey() {
        return StringUtils.toDelimitedString(CLASS_NAME, institutionId, entity, code);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StatusCodeIds that = (StatusCodeIds) o;
        return Objects.equals(institutionId, that.institutionId) &&
                Objects.equals(entity, that.entity) &&
                Objects.equals(code, that.code);
    }

    @Override
    public int hashCode() {
        return Objects.hash(CLASS_NAME, institutionId, entity, code);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("StatusCodeIds{");
        sb.append("institutionId='").append(institutionId).append('\'');
        sb.append(", entity='").append(entity).append('\'');
        sb.append(", code='").append(code).append('\'');
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}
