package cn.quant.baa.pay.jpa.entity;

import cn.quant.spring.data.jpa.entity.EntityPrimaryIds;
import cn.quant.spring.util.StringUtils;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import java.io.Serializable;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/22 0022.
 */
@Embeddable
public class PayAccountIds extends EntityPrimaryIds implements Serializable {

    private static final long serialVersionUID = 5987381896875415656L;

    private static final String CLASS_NAME = PayAccountEntity.class.getSimpleName();

    @Column(name = "PAY_CHAN_CODE", nullable = false, updatable = false, length = 4)
    private String payChanCode;

    @Column(name = "PAY_ACCT_ID", nullable = false, updatable = false, length = 64)
    private String payAcctId;

    public String getPayChanCode() {
        return payChanCode;
    }

    public void setPayChanCode(String payChanCode) {
        this.payChanCode = payChanCode;
    }

    public String getPayAcctId() {
        return payAcctId;
    }

    public void setPayAcctId(String payAcctId) {
        this.payAcctId = payAcctId;
    }

    @Override
    public String getPersistentKey() {
        return StringUtils.toDelimitedString(CLASS_NAME, payChanCode, payAcctId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PayAccountIds)) return false;
        PayAccountIds that = (PayAccountIds) o;
        return Objects.equals(payChanCode, that.payChanCode) &&
                Objects.equals(payAcctId, that.payAcctId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(CLASS_NAME, payChanCode, payAcctId);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("PayAccountIds{");
        sb.append("payChanCode='").append(payChanCode).append('\'');
        sb.append(", payAcctId='").append(payAcctId).append('\'');
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}
