package cn.quant.baa.pay.jpa.entity;

import cn.quant.baa.pay.dict.AccessCode;
import cn.quant.baa.pay.dict.AccessType;
import cn.quant.spring.data.jpa.entity.EntityPrimaryIds;
import cn.quant.spring.util.StringUtils;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import java.io.Serializable;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/22 0022.
 */
@Embeddable
public class PayFeatureIds extends EntityPrimaryIds implements Serializable {

    private static final long serialVersionUID = -8852766242045564647L;

    private final static String CLASS_NAME = PayFeatureEntity.class.getSimpleName();

    @Column(name = "PAY_CHAN_CODE", nullable = false, updatable = false, length = 4)
    private String payChanCode;

    @Enumerated(value = EnumType.STRING)
    @Column(name = "ACCESS_CODE", nullable = false, updatable = false, length = 3)
    private AccessCode accessCode;

    public String getPayChanCode() {
        return payChanCode;
    }

    public void setPayChanCode(String payChanCode) {
        this.payChanCode = payChanCode;
    }

    public AccessCode getAccessCode() {
        return accessCode;
    }

    public void setAccessCode(AccessCode accessCode) {
        this.accessCode = accessCode;
    }

    @Override
    public String getPersistentKey() {
        return StringUtils.toDelimitedString(CLASS_NAME, payChanCode, accessCode);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PayFeatureIds)) return false;
        PayFeatureIds that = (PayFeatureIds) o;
        return Objects.equals(payChanCode, that.payChanCode) &&
                Objects.equals(accessCode, that.accessCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(CLASS_NAME, payChanCode, accessCode);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("PayFeatureIds{");
        sb.append("payChanCode='").append(payChanCode).append('\'');
        sb.append(", accessCode='").append(accessCode).append('\'');
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}
