package cn.quant.baa.pay.jpa.entity;

import cn.quant.spring.data.jpa.entity.EntityPrimaryIds;
import cn.quant.spring.util.StringUtils;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import java.io.Serializable;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/26 0026.
 */
@Embeddable
public class PayHistoryIds extends EntityPrimaryIds implements Serializable {
    public final static String CLASS_NAME = PayHistoryEntity.class.getSimpleName();

    @Column(name = "INSTITUTION_ID", nullable = false, updatable = false, length = 4)
    private String institutionId;

    @Column(name = "PRODUCT_ID", nullable = false, updatable = false, length = 4)
    private String productId;

    @Column(name = "EXTERNAL_ORDER_NO", nullable = false, updatable = false, length = 64)
    private String externalOrderNo;


    public String getInstitutionId() {
        return institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getExternalOrderNo() {
        return externalOrderNo;
    }

    public void setExternalOrderNo(String externalOrderNo) {
        this.externalOrderNo = externalOrderNo;
    }

    @Override
    public String getPersistentKey() {
        return StringUtils.toDelimitedString(CLASS_NAME, institutionId, productId, externalOrderNo);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PayHistoryIds that = (PayHistoryIds) o;
        return Objects.equals(institutionId, that.institutionId) &&
                Objects.equals(productId, that.productId) &&
                Objects.equals(externalOrderNo, that.externalOrderNo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(CLASS_NAME, institutionId, productId, externalOrderNo);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("PayHistoryIds{");
        sb.append("institutionId='").append(institutionId).append('\'');
        sb.append(", productId='").append(productId).append('\'');
        sb.append(", externalOrderNo='").append(externalOrderNo).append('\'');
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}
