package cn.quant.baa.pay.acquirer;

import cn.quant.baa.pay.jpa.entity.*;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import org.springframework.beans.BeanUtils;

import java.util.Collection;
import java.util.Map;

/**
 * Created by Administrator on 2021/8/22 0022.
 */
public class AcquirerConfigurer {

    private Table<Class, Object, Object> bigTable = Tables.newCustomTable(Maps.newHashMap(), new Supplier() {
        public Map<Object, Object> get() {
            return Maps.newLinkedHashMap();
        }
    });


    public AcquirerConfiguration configure(Collection<MchChannelEntity> entities){
        AcquirerConfiguration configuration = new AcquirerConfiguration();
        for (MchChannelEntity entity : entities) {
            AcquirerProperties profile = configure(entity);
            configuration.add(profile);
        }
        return configuration;
    }

    public void release(){
        bigTable.clear();
    }

    public AcquirerProperties configure(MchChannelEntity entity) {

        AcquirerProperties profile = new AcquirerProperties();
        profile.setMchChanId(entity.getId());
        profile.setPayChanCode(entity.getPayChanCode());
        profile.setPayAcctId(entity.getPayAcctId());
        PayAccountIds accountIds = new PayAccountIds();
        accountIds.setPayAcctId(entity.getPayAcctId());
        accountIds.setPayChanCode(entity.getPayChanCode());
        PayAccountEntity account = (PayAccountEntity) bigTable.get(PayAccountEntity.class, accountIds);
        BeanUtils.copyProperties(account, profile);

        PayFeatureIds featureIds = new PayFeatureIds();
        featureIds.setPayChanCode(entity.getPayChanCode());
        featureIds.setAccessCode(entity.getAccessCode());

        PayFeatureEntity feature = (PayFeatureEntity) bigTable.get(PayFeatureEntity.class, featureIds);
        BeanUtils.copyProperties(feature, profile);
        profile.setAccessCode(entity.getAccessCode());

        PayAppEntity app = (PayAppEntity) bigTable.get(PayAppEntity.class, entity.getPayAppId());
        BeanUtils.copyProperties(app, profile);

        return profile;
    }

    public PayFeature accounts(Collection<PayAccountEntity> entities) {

        for (PayAccountEntity entity : entities) {
            bigTable.put(entity.getClass(), entity.getIds(), entity);
        }

        return new PayFeature();
    }

    public class PayFeature {
        public PayApp features(Collection<PayFeatureEntity> entities) {
            for (PayFeatureEntity entity : entities) {
                bigTable.put(entity.getClass(), entity.getIds(), entity);
            }
            return new PayApp();
        }
    }

    public class PayApp {
        public AcquirerConfigurer apps(Collection<PayAppEntity> entities) {
            for (PayAppEntity entity : entities) {
                bigTable.put(entity.getClass(), entity.getPayAppId(), entity);
            }
            return AcquirerConfigurer.this;
        }
    }
}
