package cn.quant.baa.pay.rest;

import cn.quant.baa.pay.annotation.BusinessMapping;
import cn.quant.baa.pay.context.TransactionSession;
import cn.quant.baa.pay.model.BusinessRequest;
import cn.quant.baa.pay.model.web.CheckPayRequestData;
import cn.quant.baa.pay.model.web.CheckRefundRequestData;
import cn.quant.baa.pay.model.web.PayRequestData;
import cn.quant.baa.pay.service.TransactionService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * Author: Lipeng Liu
 * Date: 2021/9/9
 * Time: 上午9:51
 * Description: No Description
 */
@Controller
//@RestController
@RequestMapping("pay")
public class PayTestController {

    ObjectMapper objectMapper = new ObjectMapper();

    @Autowired
    private TransactionService transactionService;

    @GetMapping("")
    public String getPay(Model model) {
        return "pay/index";
    }

    @RequestMapping("h5")
    public String getH5(Model model) {
        return "pay/h5";
    }

    @RequestMapping("checkPay")
    public String check(CheckPayRequestData data, Model model, HttpServletRequest servletRequest) {
        String res = "";
        if (servletRequest.getMethod().equals("POST")) {
            res = transactionService.checkPay(data).toString();
        }
        model.addAttribute("res", res);
        return "pay/checkPay";
    }

    @RequestMapping("checkRefund")
    public String check(CheckRefundRequestData data, Model model, HttpServletRequest servletRequest) {
        String res = "";
        if (servletRequest.getMethod().equals("POST")) {
            res = transactionService.checkRefund(data).toString();
        }
        model.addAttribute("res", res);
        return "pay/checkRefund";
    }


    @PostMapping("goPay")
    @BusinessMapping(session = 1)
    @ResponseBody
    public JsonNode goPay(@RequestBody(required = false) BusinessRequest<PayRequestData> requestData) {
        PayRequestData data = requestData.getData();
        String str = "{\"subject\":\"测试订单1\",\"mchId\":\"wx2f44c7fe7b08458d\",\"chanId\":\"75772285618946307\",\"outTradeNo\":\"11111111223\",\"originalAmount\":\"110.00\",\"amount\":0.01,\"discounts\":\"10.00\",\"notifyUrl\":\"http://127.0.0.1:8080/notifyUrl\",\"buyerId\":\"777777\",\"attach\":\"AAAA-BBBB-1111-2222\",\"creditAmount\":\"10.00\",\"cashAmount\":\"10\",\"goodsDetail\":[{\"goodsNo\":\"123123\",\"goodsId\":\"11111\",\"goodsName\":\"商品1\",\"quantity\":2,\"price\":\"10.00\",\"discounts\":\"2.5\",\"amount\":\"17.5\",\"attach\":\"---\",\"creditAmount\":123,\"cashAmount\":123}]}";
        try {
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            PayRequestData payRequestData = objectMapper.readValue(str, PayRequestData.class);
            String[] temp = data.getChanId().split("_");
            payRequestData.setChanId(temp[0]);
            payRequestData.setMchId(temp[1]);
            payRequestData.setOutTradeNo(data.getOutTradeNo());
            payRequestData.setSubject(data.getSubject());
            payRequestData.setAmount(data.getAmount());
            payRequestData.setNotifyUrl("http://127.0.0.1:8080/notifyUrl");
            JsonNode res = transactionService.pay(payRequestData);
            return res;
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return objectMapper.createObjectNode();
    }

}