package cn.quant.baa.pay.jpa.entity;

import cn.quant.spring.data.jpa.entity.DescribablePartitionEntity;
import cn.quant.spring.data.jpa.entity.DescriptionEntity;
import cn.quant.spring.util.StringUtils;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * Created by Administrator on 2021/8/24 0024.
 */
@Entity
@Table(name = "customer")
public class CustomerEntity extends DescribablePartitionEntity implements Serializable {

    private final static String CLASS_NAME = CustomerEntity.class.getSimpleName();
    private static final long serialVersionUID = 2591866260454689833L;

    @Id
    @Column(name = "CUSTOMER_ID", nullable = false)
    private Long customerId;

    @Column(name = "INSTITUTION_ID", nullable = false, length = 4)
    private String institutionId;

    @Column(name = "CUSTOMER_REF_NO", nullable = false, length = 32)
    private String customerRefNo;

    @Column(name = "FULL_NAME", nullable = false, length = 72)
    private String fullName;

    @Column(name = "MOBILE_PHONE", nullable = false, length = 18)
    private String mobilePhone;

    @Column(name = "MEMBER_TYPE", nullable = false, length = 4)
    private String memberType;

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getInstitutionId() {
        return institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public String getCustomerRefNo() {
        return customerRefNo;
    }

    public void setCustomerRefNo(String customerRefNo) {
        this.customerRefNo = customerRefNo;
    }

    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getMobilePhone() {
        return mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public String getMemberType() {
        return memberType;
    }

    public void setMemberType(String memberType) {
        this.memberType = memberType;
    }

    @Override
    public String getPersistentKey() {
        return StringUtils.toDelimitedString(CLASS_NAME, customerId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CustomerEntity that = (CustomerEntity) o;
        return Objects.equals(customerId, that.customerId);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("CustomerEntity{");
        sb.append("customerId=").append(customerId);
        sb.append(", institutionId='").append(institutionId).append('\'');
        sb.append(", customerRefNo='").append(customerRefNo).append('\'');
        sb.append(", fullName='").append(fullName).append('\'');
        sb.append(", mobilePhone='").append(mobilePhone).append('\'');
        sb.append(", memberType='").append(memberType).append('\'');
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}
