package cn.quant.baa.pay;

import cn.quant.baa.pay.dict.MessageEnum;
import org.slf4j.Logger;

/**
 * @author hechao
 * @description
 * @date 2020/7/28 12:44
 * @modify 2020/7/28 12:44 by hechao
 */
public class BusinessException extends RuntimeException {
    private String errorCode;
    private String errorNumer;

    public BusinessException(MessageEnum messageEnum, String message) {
        super(message);
        this.errorCode = messageEnum.name();
        this.errorNumer=messageEnum.code;
    }

    @Override
    public String getMessage() {
        return getMessage(errorCode, errorNumer, super.getMessage());
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorNumer() {
        return errorNumer;
    }

    public void setErrorNumer(String errorNumer) {
        this.errorNumer = errorNumer;
    }

    public String print(Logger logger) {
        String msg = toString(this);
        logger.error(msg, this);
        this.printStackTrace();
        return msg;
    }

    public static <T extends BusinessException> String getMessage(String code, String num, String msg) {
        return code + "-" + num + ": " + msg;
    }

    public static <T extends BusinessException> String toString(T t) {
        return getMessage(t.getErrorCode(), t.getErrorCode(), t.getMessage());
    }
}