package cn.quant.baa.pay.config;

import cn.quant.baa.pay.model.MerchantAcquirerProfile;
import cn.quant.spring.ExistsException;
import cn.quant.spring.util.StringUtils;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/**
 * Created by Administrator on 2021/8/22 0022.
 */
public class MerchantAcquirerBuilder {

    private Table<String, String, Collection<MerchantAcquirerProfile>> bigTable = Tables.newCustomTable(Maps.newHashMap()
            , new Supplier() {
                public Map<String, Collection<MerchantAcquirerProfile>> get() {
                    return Maps.newLinkedHashMap();
                }
            });

    private Map<Long, MerchantAcquirerProfile> map = new HashMap<>();

    void add(MerchantAcquirerProfile profile) {
        if (map.containsKey(profile.getMchChanId())) {
            throw new ExistsException(StringUtils.format("Existing merchant acquirer {}.", profile.getMchChanId()));
        }
        map.put(profile.getMchChanId(), profile);

        String appId = profile.getPayAppId();
        String chanCode = profile.getPayChanCode();
        Collection<MerchantAcquirerProfile> profiles = bigTable.get(appId, chanCode);
        if (profiles == null) {
            profiles = new LinkedList<>();
            bigTable.put(appId, chanCode, profiles);
        }
        profiles.add(profile);
    }

    public Map<String, Collection<MerchantAcquirerProfile>> get(String mchId, String channel) {
        Collection<MerchantAcquirerProfile> profiles = bigTable.get(mchId, channel);
        return toMap(profiles);
    }

    public Map<String, Collection<MerchantAcquirerProfile>> get(String mchId) {
        return bigTable.row(mchId);
    }

    public Map<String, Collection<MerchantAcquirerProfile>> toMap(Collection<MerchantAcquirerProfile> profiles) {
        Map<String, Collection<MerchantAcquirerProfile>> map = new HashMap<>();
        for (MerchantAcquirerProfile profile : profiles) {
            Collection<MerchantAcquirerProfile> collection = map.get(profile.getPayChanCode());
            if (collection == null) {
                collection = new LinkedList<>();
                map.put(profile.getPayChanCode(), collection);
            }
            collection.add(profile);
        }
        return map;
    }

    public MerchantAcquirerProfile get(Long channelId) {
        return map.get(channelId);
    }
};