package cn.quantgroup.financial.service;

import cn.quantgroup.financial.BootStarter;
import cn.quantgroup.financial.model.MailInfo;
import cn.quantgroup.financial.service.http.IHttpService;
import cn.quantgroup.financial.service.sys.IMailService;
import com.alibaba.fastjson.JSON;
import org.apache.http.protocol.HttpService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.SpringApplicationConfiguration;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by WuKong on 2017/2/19.
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringApplicationConfiguration(classes = BootStarter.class)
@WebAppConfiguration
@ActiveProfiles("local")
public class SystemServiceTest {

    @Autowired
    IMailService mailService;

    @Autowired
    IHttpService httpService;

    private Object lock = new Object();
    private static final Logger logger = LoggerFactory.getLogger(SystemServiceTest.class);

    @Test
    public void testSendMailNotice(){
        MailInfo mailInfo = new MailInfo();
        mailService.saveMailInfo(mailInfo);
        synchronized (lock) {
            try {
                lock.wait();
            } catch (InterruptedException e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    @Test
    public void testJSONMailInfo(){
        MailInfo mailInfo = new MailInfo();
        mailInfo.setMailtype(new Integer(1).byteValue());
        mailInfo.setMail("bo.wang@quantgroup.cn");
        System.out.println(JSON.toJSONString(mailInfo));
    }

    @Test
    public void testRepiar(){
        Map<String,Long> map = new HashMap<String,Long>(){
            {
                put("HT100000201702190070662",19551813L);
                put("HT100000201701250046308",20744387L);
                put("HT100000201702190070607",28411904L);
                put("HT100000201702180069923",29728636L);
                put("HT100000201612030022651",33491234L);
                put("HT100000201701010030266",35262308L);
                put("HT100000201702180069146",37668865L);
                put("HT100000201701120036083",37890845L);
                put("HT100000201702200071526",37981861L);
                put("HT100000201701130037019",38101879L);
                put("HT100000201701130037121",38104095L);
                put("HT100000201702200071720",38129325L);
                put("HT100000201702130063062",38179967L);
                put("HT100000201701170039532",38280243L);
                put("HT100000201701150038228",38384069L);
                put("HT100000201701150038601",38434691L);
                put("HT100000201702200071671",38485967L);
                put("HT100000201701160038866",38549793L);
                put("HT100000201701170039214",38648871L);
                put("HT100000201701170039374",38653649L);
                put("HT100000201701170039422",38654123L);
                put("HT100000201701210042288",39282503L);
                put("HT100000201701240043615",39625699L);
                put("HT100000201701240044919",39719231L);
                put("HT100000201701250045767",39746565L);
                put("HT100000201701250046091",39804749L);
                put("HT100000201702190070786",40323569L);
                put("HT100000201702040051093",40349405L);
                put("HT100000201702040052055",40376751L);
                put("HT100000201702070056798",40661193L);
                put("HT100000201702190070452",40812653L);
                put("HT100000201702090058879",40822031L);
                put("HT100000201702090058682",40839999L);
                put("HT100000201702140064604",40904941L);
                put("HT100000201702100059619",40933323L);
                put("HT100000201702100059699",40934479L);
                put("HT100000201702110060651",41047661L);
                put("HT100000201702110060789",41070977L);
                put("HT100000201702120061302",41114939L);
                put("HT100000201702120061775",41141437L);
                put("HT100000201702120061846",41145541L);
                put("HT100000201702180069074",41145949L);
                put("HT100000201702130062408",41221577L);
                put("HT100000201702130062493",41228535L);
                put("HT100000201702200071517",41229339L);
                put("HT100000201702130063145",41273787L);
                put("HT100000201702180069741",41338673L);
                put("HT100000201702140064072",41341559L);
                put("HT100000201702140064149",41354269L);
                put("HT100000201702140064150",41354473L);
                put("HT100000201702190070592",41524143L);
                put("HT100000201702160066451",41530607L);
                put("HT100000201702160066595",41565807L);
                put("HT100000201702160067039",41576521L);
                put("HT100000201702160067459",41640327L);
                put("HT100000201702160067487",41641975L);
                put("HT100000201702170067546",41677183L);
                put("HT100000201702170068276",41693931L);
                put("HT100000201702170068279",41694233L);
                put("HT100000201702170068343",41695277L);
                put("HT100000201702180069934",41712803L);
                put("HT100000201702170068510",41743523L);
                put("HT100000201702180068744",41759985L);
                put("HT100000201702180069107",41761149L);
                put("HT100000201702190071224",41764699L);
                put("HT100000201702180068588",41769875L);
                put("HT100000201702180068667",41794285L);
                put("HT100000201702180068674",41794411L);
                put("HT100000201702180068868",41796755L);
                put("HT100000201702180068964",41800847L);
                put("HT100000201702190070583",41804359L);
                put("HT100000201702180069050",41805337L);
                put("HT100000201702180069058",41806159L);
                put("HT100000201702180069069",41806565L);
                put("HT100000201702190071079",41808329L);
                put("HT100000201702180069767",41830961L);
                put("HT100000201702180069768",41833977L);
                put("HT100000201702180069770",41837153L);
                put("HT100000201702180069571",41838607L);
                put("HT100000201702180069564",41839259L);
                put("HT100000201702180069633",41841543L);
                put("HT100000201702180069655",41844773L);
                put("HT100000201702180069774",41849483L);
                put("HT100000201702180069792",41854155L);
                put("HT100000201702190070746",41856701L);
                put("HT100000201702190071102",41866627L);
                put("HT100000201702180069869",41877013L);
                put("HT100000201702180069881",41880071L);
                put("HT100000201702180069925",41881209L);
                put("HT100000201702180069946",41881539L);
                put("HT100000201702180069952",41881859L);
                put("HT100000201702180069970",41882423L);
                put("HT100000201702180069982",41882835L);
                put("HT100000201702180070011",41883619L);
                put("HT100000201702190070466",41884171L);
                put("HT100000201702190070566",41888381L);
                put("HT100000201702190070581",41893887L);
                put("HT100000201702190071078",41895933L);
                put("HT100000201702190070934",41897245L);
                put("HT100000201702190070588",41898117L);
                put("HT100000201702190070391",41908761L);
                put("HT100000201702190071080",41908947L);
                put("HT100000201702190070401",41909229L);
                put("HT100000201702190070449",41911683L);
                put("HT100000201702190070451",41912015L);
                put("HT100000201702190070458",41912697L);
                put("HT100000201702190070469",41913483L);
                put("HT100000201702190070514",41913529L);
                put("HT100000201702190070482",41913577L);
                put("HT100000201702190070503",41914137L);
                put("HT100000201702190071081",41917497L);
                put("HT100000201702200071763",41920813L);
                put("HT100000201702190070616",41929497L);
                put("HT100000201702190070655",41932317L);
                put("HT100000201702190070665",41932771L);
                put("HT100000201702190070767",41932983L);
                put("HT100000201702190070674",41933037L);
                put("HT100000201702190070923",41933373L);
                put("HT100000201702190070757",41933993L);
                put("HT100000201702190070748",41934399L);
                put("HT100000201702190070749",41934545L);
                put("HT100000201702190070750",41934775L);
                put("HT100000201702190070752",41934901L);
                put("HT100000201702190070755",41934987L);
                put("HT100000201702190070759",41935445L);
                put("HT100000201702190070764",41935583L);
                put("HT100000201702190070762",41935595L);
                put("HT100000201702190070769",41935729L);
                put("HT100000201702190070768",41935977L);
                put("HT100000201702190070770",41936189L);
                put("HT100000201702190070773",41936419L);
                put("HT100000201702190070790",41936429L);
                put("HT100000201702190070782",41936581L);
                put("HT100000201702190070787",41936667L);
                put("HT100000201702190070800",41936781L);
                put("HT100000201702190070798",41936793L);
                put("HT100000201702190070793",41936827L);
                put("HT100000201702190070814",41936947L);
                put("HT100000201702190070797",41936967L);
                put("HT100000201702190070792",41936991L);
                put("HT100000201702190070796",41937133L);
                put("HT100000201702190070820",41937355L);
                put("HT100000201702190070813",41937411L);
                put("HT100000201702190070801",41937431L);
                put("HT100000201702190070816",41937527L);
                put("HT100000201702190070819",41937589L);
                put("HT100000201702190070817",41937615L);
                put("HT100000201702190070822",41944897L);
                put("HT100000201702190070823",41945847L);
                put("HT100000201702190070825",41948447L);
                put("HT100000201702190070827",41948601L);
                put("HT100000201702190070828",41948605L);
                put("HT100000201702190070826",41948795L);
                put("HT100000201702190070831",41948959L);
                put("HT100000201702190070832",41949089L);
                put("HT100000201702190070833",41949149L);
                put("HT100000201702190070834",41949225L);
                put("HT100000201702190070839",41949433L);
                put("HT100000201702190070835",41949533L);
                put("HT100000201702190070836",41949559L);
                put("HT100000201702190070843",41949753L);
                put("HT100000201702190070838",41949847L);
                put("HT100000201702190070845",41949853L);
                put("HT100000201702190070841",41949977L);
                put("HT100000201702190070844",41950141L);
                put("HT100000201702190070846",41950227L);
                put("HT100000201702190070847",41950259L);
                put("HT100000201702190070859",41950283L);
                put("HT100000201702200071282",41956559L);
                put("HT100000201702190070860",41957033L);
                put("HT100000201702190070895",41958417L);
                put("HT100000201702190070867",41958493L);
                put("HT100000201702190070861",41958861L);
                put("HT100000201702190070899",41959203L);
                put("HT100000201702190070864",41959475L);
                put("HT100000201702190070891",41959481L);
                put("HT100000201702190070862",41959525L);
                put("HT100000201702190070892",41959621L);
                put("HT100000201702190070872",41959755L);
                put("HT100000201702190070893",41959835L);
                put("HT100000201702190070869",41959841L);
                put("HT100000201702190070870",41959847L);
                put("HT100000201702190070868",41959865L);
                put("HT100000201702190070894",41959995L);
                put("HT100000201702190070901",41960031L);
                put("HT100000201702190070942",41960351L);
                put("HT100000201702190070919",41960391L);
                put("HT100000201702190070908",41960507L);
                put("HT100000201702190070905",41960687L);
                put("HT100000201702190070912",41960911L);
                put("HT100000201702190070909",41960959L);
                put("HT100000201702190070906",41961033L);
                put("HT100000201702190070910",41961265L);
                put("HT100000201702190070911",41961317L);
                put("HT100000201702190070913",41961405L);
                put("HT100000201702190070914",41961613L);
                put("HT100000201702190070915",41961681L);
                put("HT100000201702190070917",41961705L);
                put("HT100000201702190070916",41961763L);
                put("HT100000201702190070920",41961797L);
                put("HT100000201702190070918",41961897L);
                put("HT100000201702190070921",41962029L);
                put("HT100000201702190070922",41962077L);
                put("HT100000201702190070925",41962315L);
                put("HT100000201702190070927",41962323L);
                put("HT100000201702190070954",41962333L);
                put("HT100000201702190070930",41962335L);
                put("HT100000201702190070936",41962347L);
                put("HT100000201702190070938",41962541L);
                put("HT100000201702190070945",41962639L);
                put("HT100000201702190070940",41962699L);
                put("HT100000201702190070947",41962787L);
                put("HT100000201702190070943",41962849L);
                put("HT100000201702190070946",41962917L);
                put("HT100000201702190070949",41962949L);
                put("HT100000201702190070948",41963163L);
                put("HT100000201702190070951",41963411L);
                put("HT100000201702190070950",41963471L);
                put("HT100000201702190070952",41963543L);
                put("HT100000201702190070953",41963549L);
                put("HT100000201702190070955",41963669L);
                put("HT100000201702190071088",41967505L);
                put("HT100000201702200071299",41968227L);
                put("HT100000201702190071086",41969493L);
                put("HT100000201702190071082",41969961L);
                put("HT100000201702190071083",41970039L);
                put("HT100000201702190071084",41970053L);
                put("HT100000201702190071085",41970259L);
                put("HT100000201702190071089",41970601L);
                put("HT100000201702190071092",41970943L);
                put("HT100000201702190071091",41970985L);
                put("HT100000201702190071096",41971001L);
                put("HT100000201702190071094",41971075L);
                put("HT100000201702190071093",41971085L);
                put("HT100000201702190071095",41971249L);
                put("HT100000201702190071101",41971813L);
                put("HT100000201702190071097",41971867L);
                put("HT100000201702190071104",41971887L);
                put("HT100000201702190071098",41971967L);
                put("HT100000201702190071103",41972311L);
                put("HT100000201702190071105",41972569L);
                put("HT100000201702190071106",41972647L);
                put("HT100000201702190071108",41973033L);
                put("HT100000201702190071158",41973223L);
                put("HT100000201702190071109",41973393L);
                put("HT100000201702190071111",41973513L);
                put("HT100000201702190071174",41973555L);
                put("HT100000201702190071110",41973567L);
                put("HT100000201702190071112",41973849L);
                put("HT100000201702190071113",41974087L);
                put("HT100000201702190071114",41974405L);
                put("HT100000201702190071115",41974463L);
                put("HT100000201702190071126",41974831L);
                put("HT100000201702190071116",41974837L);
                put("HT100000201702190071119",41974861L);
                put("HT100000201702190071117",41975059L);
                put("HT100000201702190071118",41975115L);
                put("HT100000201702190071121",41975231L);
                put("HT100000201702190071122",41975259L);
                put("HT100000201702190071124",41975403L);
                put("HT100000201702190071125",41975417L);
                put("HT100000201702190071127",41975443L);
                put("HT100000201702190071128",41975617L);
                put("HT100000201702190071130",41975903L);
                put("HT100000201702190071129",41975951L);
                put("HT100000201702190071131",41976325L);
                put("HT100000201702190071137",41976385L);
                put("HT100000201702190071132",41976457L);
                put("HT100000201702190071134",41976559L);
                put("HT100000201702190071136",41976685L);
                put("HT100000201702190071139",41976913L);
                put("HT100000201702190071146",41976951L);
                put("HT100000201702190071140",41977095L);
                put("HT100000201702190071141",41977159L);
                put("HT100000201702190071142",41977225L);
                put("HT100000201702190071143",41977417L);
                put("HT100000201702190071144",41977671L);
                put("HT100000201702190071145",41977683L);
                put("HT100000201702190071147",41977853L);
                put("HT100000201702190071149",41977979L);
                put("HT100000201702190071159",41978355L);
                put("HT100000201702190071151",41978389L);
                put("HT100000201702190071150",41978399L);
                put("HT100000201702190071155",41978455L);
                put("HT100000201702190071164",41978645L);
                put("HT100000201702190071178",41978653L);
                put("HT100000201702190071153",41978671L);
                put("HT100000201702190071156",41978711L);
                put("HT100000201702190071160",41978755L);
                put("HT100000201702190071161",41978829L);
                put("HT100000201702190071162",41978981L);
                put("HT100000201702190071157",41978983L);
                put("HT100000201702190071166",41979331L);
                put("HT100000201702190071165",41979497L);
                put("HT100000201702190071170",41979669L);
                put("HT100000201702190071169",41979749L);
                put("HT100000201702190071172",41979869L);
                put("HT100000201702190071173",41980015L);
                put("HT100000201702190071176",41980235L);
                put("HT100000201702190071177",41980615L);
                put("HT100000201702190071188",41980743L);
                put("HT100000201702190071184",41980843L);
                put("HT100000201702190071179",41980865L);
                put("HT100000201702190071180",41980907L);
                put("HT100000201702190071182",41981031L);
                put("HT100000201702190071186",41981185L);
                put("HT100000201702190071187",41981201L);
                put("HT100000201702190071189",41981343L);
                put("HT100000201702190071190",41981833L);
                put("HT100000201702190071191",41981891L);
                put("HT100000201702190071193",41982203L);
                put("HT100000201702190071194",41982525L);
                put("HT100000201702190071195",41982699L);
                put("HT100000201702190071196",41982871L);
                put("HT100000201702190071197",41983065L);
                put("HT100000201702190071201",41983621L);
                put("HT100000201702190071202",41983629L);
                put("HT100000201702190071204",41983681L);
                put("HT100000201702190071206",41984029L);
                put("HT100000201702190071209",41984311L);
                put("HT100000201702190071208",41984717L);
                put("HT100000201702190071210",41984869L);
                put("HT100000201702190071211",41984899L);
                put("HT100000201702190071214",41985271L);
                put("HT100000201702190071215",41985545L);
                put("HT100000201702190071216",41985687L);
                put("HT100000201702190071217",41986087L);
                put("HT100000201702190071220",41986157L);
                put("HT100000201702190071218",41986207L);
                put("HT100000201702190071219",41986285L);
                put("HT100000201702190071221",41986529L);
                put("HT100000201702190071222",41986773L);
                put("HT100000201702190071225",41987105L);
                put("HT100000201702190071227",41987225L);
                put("HT100000201702200071260",42019241L);
                put("HT100000201702200071262",42019809L);
                put("HT100000201702200071261",42020163L);
                put("HT100000201702200071264",42020353L);
                put("HT100000201702200071265",42020561L);
                put("HT100000201702200071266",42020563L);
                put("HT100000201702200071268",42021027L);
                put("HT100000201702200071286",42021139L);
                put("HT100000201702200071269",42021149L);
                put("HT100000201702200071270",42021187L);
                put("HT100000201702200071272",42021203L);
                put("HT100000201702200071271",42021273L);
                put("HT100000201702200071273",42021359L);
                put("HT100000201702200071276",42021497L);
                put("HT100000201702200071304",42021505L);
                put("HT100000201702200071301",42021511L);
                put("HT100000201702200071290",42021535L);
                put("HT100000201702200071274",42021547L);
                put("HT100000201702200071279",42021567L);
                put("HT100000201702200071281",42021589L);
                put("HT100000201702200071277",42021591L);
                put("HT100000201702200071278",42021595L);
                put("HT100000201702200071288",42021637L);
                put("HT100000201702200071292",42021663L);
                put("HT100000201702200071283",42021679L);
                put("HT100000201702200071296",42021693L);
                put("HT100000201702200071298",42021705L);
                put("HT100000201702200071284",42021709L);
                put("HT100000201702200071291",42021725L);
                put("HT100000201702200071294",42021729L);
                put("HT100000201702200071287",42021733L);
                put("HT100000201702200071289",42021759L);
                put("HT100000201702200071293",42021787L);
                put("HT100000201702200071295",42021791L);
                put("HT100000201702200071303",42021797L);
                put("HT100000201702200071297",42021819L);
                put("HT100000201702200071302",42021865L);
                put("HT100000201702200071308",42021881L);
                put("HT100000201702200071312",42021931L);
                put("HT100000201702200071309",42021941L);
                put("HT100000201702200071306",42021985L);
                put("HT100000201702200071733",42022241L);
                put("HT100000201702200071531",42024275L);
                put("HT100000201702200071533",42024973L);
                put("HT100000201702200071537",42025951L);
                put("HT100000201702200071538",42026659L);
                put("HT100000201702200071554",42026879L);
                put("HT100000201702200071536",42027047L);
                put("HT100000201702200071535",42027167L);
                put("HT100000201702200071562",42027217L);
                put("HT100000201702200071555",42027311L);
                put("HT100000201702200071551",42027373L);
                put("HT100000201702200071621",42027719L);
                put("HT100000201702200071622",42028969L);
                put("HT100000201702200071623",42029465L);
                put("HT100000201702200071627",42030839L);
                put("HT100000201702200071629",42031571L);
                put("HT100000201702200071630",42031647L);
                put("HT100000201702200071633",42034551L);
                put("HT100000201702200071635",42035295L);
                put("HT100000201702200071634",42035525L);
                put("HT100000201702200071636",42036393L);
                put("HT100000201702200071639",42037147L);
                put("HT100000201702200071645",42037995L);
                put("HT100000201702200071735",42038519L);
                put("HT100000201702200071643",42038541L);
                put("HT100000201702200071648",42039099L);
                put("HT100000201702200071647",42039121L);
                put("HT100000201702200071657",42039125L);
                put("HT100000201702200071669",42039127L);
                put("HT100000201702200071652",42039273L);
                put("HT100000201702200071646",42039303L);
                put("HT100000201702200071662",42039361L);
                put("HT100000201702200071660",42039483L);
                put("HT100000201702200071673",42039521L);
                put("HT100000201702200071682",42039541L);
                put("HT100000201702200071667",42039547L);
                put("HT100000201702200071677",42039567L);
                put("HT100000201702200071678",42039609L);
                put("HT100000201702200071676",42039823L);
                put("HT100000201702200071718",42041825L);
                put("HT100000201702200071741",42042095L);
                put("HT100000201702200071738",42042179L);
                put("HT100000201702200071721",42042189L);
                put("HT100000201702200071761",42042261L);
                put("HT100000201702200071726",42042295L);
                put("HT100000201702200071734",42042391L);
                put("HT100000201702200071746",42042635L);
                put("HT100000201702200071740",42042643L);
                put("HT100000201702200071742",42042673L);
                put("HT100000201702200071749",42042723L);
                put("HT100000201702200071750",42043039L);
                put("HT100000201702200071751",42043163L);
                put("HT100000201702200071753",42043219L);
                put("HT100000201702200071760",42043469L);
                put("HT100000201702200071772",42045747L);
                put("HT100000201702200071767",42046373L);
                put("HT100000201702200071769",42046423L);
                put("HT100000201702200071766",42046465L);
                put("HT100000201702200071764",42046553L);
                put("HT100000201702200071770",42046679L);
                put("HT100000201702200071773",42046707L);
            }
        };

        for(String contractNo:map.keySet()){
            String result = httpService.get("http://172.20.1.50:9008/system/payment/update?contractNo="+contractNo+"&loanHistoryId="+map.get(contractNo));
            logger.info("result={}",result);
        }
    }
}
