package cn.quantgroup.financial.service;

import cn.quantgroup.financial.BootStarter;
import cn.quantgroup.financial.constant.CompensationStatus;
import cn.quantgroup.financial.exception.ArgsInvaildException;
import cn.quantgroup.financial.exception.FieldInsufficientException;
import cn.quantgroup.financial.model.PaymentDetail;
import cn.quantgroup.financial.model.RepaymentPlanStatus;
import com.alibaba.fastjson.JSON;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.SpringApplicationConfiguration;
import org.springframework.core.env.Environment;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * Created by WuKong on 2017/1/9.
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringApplicationConfiguration(classes = BootStarter.class)
@WebAppConfiguration
@ActiveProfiles("test")
public class ApiCommonServiceTest {

    @Autowired
    Environment env;
    @Autowired
    IApiCommonService iApiCommonService;

    private static Logger logger = LoggerFactory.getLogger(ApiCommonServiceTest.class);

    @Test
    public void testGetRepaymentPlanStatus(){
        try {
            List<RepaymentPlanStatus> repaymentPlanStatusList = iApiCommonService.getRepaymentPlanStatus(3001l,null);
            logger.info("json={}",JSON.toJSONString(repaymentPlanStatusList));
        } catch (ArgsInvaildException e) {
            logger.error(e.getMessage(),e);
        }
    }

    @Test
    public void testSavePaymentDetailAndRepaymentPlan(){
        String json = "{\n" +
                "  \"paymentCorpName\": \"湖北消金\",\n" +
                "  \"userIdType\": 0,\n" +
                "  \"repaymentPlanDetailList\": [\n" +
                "    {\n" +
                "      \"principal\": 1980.13,\n" +
                "      \"currentTerm\": 1,\n" +
                "      \"fundingServiceFee\": 0,\n" +
                "      \"interest\": 60.00,\n" +
                "      \"lhpServiceFee\": 180,\n" +
                "      \"repaymentPlanId\": 101,\n" +
                "      \"discountType\": \"\",\n" +
                "      \"deadLine\": \"2016-03-30\"\n" +
                "    },\n" +
                "    {\n" +
                "      \"principal\": 1999.93,\n" +
                "      \"currentTerm\": 2,\n" +
                "      \"fundingServiceFee\": 0,\n" +
                "      \"interest\": 40.20,\n" +
                "      \"lhpServiceFee\": 180,\n" +
                "      \"repaymentPlanId\": 102,\n" +
                "      \"discountType\": \"\",\n" +
                "      \"deadLine\": \"2016-04-29\"\n" +
                "    },\n" +
                "    {\n" +
                "      \"principal\": 2019.93,\n" +
                "      \"currentTerm\": 3,\n" +
                "      \"fundingServiceFee\": 0,\n" +
                "      \"interest\": 20.20,\n" +
                "      \"lhpServiceFee\": 180,\n" +
                "      \"repaymentPlanId\": 103,\n" +
                "      \"discountType\": \"\",\n" +
                "      \"deadLine\": \"2016-05-30\"\n" +
                "    }\n" +
                "  ],\n" +
                "  \"userPhoneNo\": \"18000000000\",\n" +
                "  \"totalPrincipal\": 6000,\n" +
                "  \"fundingCorpName\": \"湖北消金\",\n" +
                "  \"userName\": \"测试\",\n" +
                "  \"userId\": 1001,\n" +
                "  \"loanCreateAt\": 1483945900051,\n" +
                "  \"loanHistoryId\": 3001,\n" +
                "  \"paymentCorpId\": 290,\n" +
                "  \"loanManifestHistoryId\": 2001,\n" +
                "  \"fundingCorpId\": 290,\n" +
                "  \"loanPaidAt\": 1483945900051,\n" +
                "  \"userIdNo\": \"100000000000000000\",\n" +
                "  \"contractTotalTerm\": 3\n" +
                "}";
        PaymentDetail paymentDetail = JSON.parseObject(json, PaymentDetail.class);
        try {
            iApiCommonService.savePaymentDetailAndRepaymentPlan(paymentDetail);
        } catch (FieldInsufficientException e) {
            logger.error(e.getMessage(),e);
        }
    }

    @Test
    public void testQueryData(){

        List<Long> loanList = new ArrayList<>(Arrays.asList(32633136L,32633504L,32237770L,33125582L,33126528L,33126870L,31084840L,33127912L,20145793L,33129568L,33130092L,33129446L,33130418L,33250214L,33250888L,33250906L,33250850L,33265960L,33266094L,33266796L,33266682L,33267226L,33249432L,33267754L,33267570L,33266972L,33267902L,33268030L,29867298L,33270350L,33270828L,33266464L,33271306L,33482662L,26931928L,33483488L,10816919L,33115276L,33487826L,33487676L,33488120L,33489440L,33489864L,33489546L,33490170L,33490608L,33490922L,33368040L,33491868L,33493080L,33931620L,33931660L,33933850L,34431958L,34489392L,34493358L,34687078L,34688706L,34688732L,34688962L,34689274L,34684686L,34689730L,34689556L,34686742L,34687372L,23958002L,34690298L,34690576L,34690846L,34691030L,34691422L,34691654L,34691244L,34660512L,34692028L,34692204L,34692288L,34692128L,34692292L,34692854L,34692080L,34014972L,34693444L,34693398L,33216386L,34693166L,34693562L,34693774L,34693948L,34694026L,34694282L,34694034L,34694624L,34694290L,34694662L,34694618L,34695020L,34695578L,34695644L,34695216L,34696006L,34696054L,34695996L,34695154L,34695880L,34696374L,34696522L,34696614L,34696896L,33240240L,34696964L,34697134L,34696712L,34697256L,34697566L,34697858L,35268644L,35293372L,35393774L,35609626L,36575410L,36576290L,36576860L,36572208L,36577032L,36624432L,36625316L,32949658L,36518106L,36625634L,36564606L,36668552L,36696080L,34031028L,36799792L,36800964L,36800972L,36801380L,36801500L,36801344L,36755260L,36803482L,36803588L,36804052L,36869442L,36869900L,36867562L,36870236L,36870500L,36871064L,36871308L,36871422L,36871618L,36871852L,36872732L,36874112L,36874424L,22032478L,36894518L,36910110L,36997088L,36997070L,36629792L,36997648L,36997600L,36998092L,36990890L,36992972L,36999876L,36999990L,37000814L,37016578L,37016626L,37017074L,37017384L,37017552L,37018242L,37018386L,37018750L,36651866L,37034118L,37032792L,37034860L,37034912L,37034574L,37036454L,33238590L,35609246L,37035078L,37036894L,37037362L,37038342L,37105218L,37105320L,37105248L,37105822L,37126462L,37126514L,37126876L,37127166L,37127710L,37128190L,37128376L,37128464L,37233954L,37234848L,37236042L,37236714L,37224598L,17426513L,37232194L,37239294L,37239854L,37239786L,37239484L,37240118L,37240764L,37240942L,37257068L,37245260L,37266356L,37267518L,37274184L,37274428L,37240428L,37274940L,37263232L,37274994L,37307560L,37382084L,37383668L,37382446L,37285570L,37384162L,37383998L,37050414L,37385942L,36666226L,37386820L,37347932L,37387306L,37295294L,37387472L,37387500L,37410015L,37360290L,37410859L,37411037L,37411061L,37411085L,37411431L,37461747L,25770978L,37462727L,37462371L,37462999L,37462631L,37460101L,37463805L,37463847L,37464213L,37464405L,37459987L,37465585L,37465027L,37465977L,37491765L,37453241L,37493225L,37494335L,37495187L,37494727L,37495973L,34268692L,37496177L,37496207L,37495643L,37233842L,37498087L,37498723L,37498831L,37500243L,37595403L,37595715L,37532143L,37596063L,37596227L,37596281L,37596487L,37560547L,37038568L,37597145L,37596597L,37597301L,37598153L,36193818L,37597827L,37625937L,37626911L,37637367L,37637547L,37638291L,37639289L,37639527L,37639851L,35638960L,37566891L,37601137L,37610905L,37613107L,37613393L,37615491L,37625533L,37631033L,37637665L,37639533L,37640661L,37641971L,37642661L,37643267L,37643297L,37644595L,37630553L,37644859L,37151236L,37735493L,37735195L,37736245L,37736597L,37512699L,37672295L,37736907L,37737153L,37735997L,37736935L,37737667L,37738369L,37738425L,37736443L,37737319L,37738713L,37738911L,37738605L,37738705L,37738955L,37739141L,37739289L,37738773L,37739931L,37739899L,37739955L,37740933L,37740877L,37741181L,37740711L,37741245L,37741001L,37740575L,37741465L,37620067L,37741825L,37741737L,37737609L,37741797L,37742173L,37741079L,37742881L,10996907L,37782195L,37794355L,37794961L,37800929L,37803891L,37783025L,37804861L,37804869L,37805107L,37854093L,37853069L,37418955L,37861035L,37441147L,37861759L,36363026L,37862083L,37862471L,37861481L,37868117L,37871581L,37871457L,37912505L,37920913L,37924225L,37920991L,37922799L,37675573L,37924511L,37924435L,37929793L,37860829L,37928703L,37929819L,37930219L,37930675L,37930981L,37931069L,37930595L,37597265L,37931175L,37913511L,37931883L,37932103L,37931569L,37932225L,37933129L,37951749L,37952287L,37952141L,37952269L,37951983L,37952399L,37952447L,37952291L,37951307L,37952709L,37951001L,37952617L,37952195L,37952769L,37953121L,37953157L,36038378L,37953655L,37671585L,37953359L,37952521L,37953867L,37952787L,37954097L,25888154L,37979923L,37981333L,37981663L,34221146L,37983267L,37908171L,37384026L,37985289L,37985857L,37987927L,37987907L,37996397L,37995945L,37997197L,37997675L,37997939L,37998199L,37898531L,37995685L,37998347L,37998821L,37982637L,37999313L,37996319L,37999219L,37999481L,37999599L,38004283L,38007617L,38007795L,38007819L,38008075L,38011943L,38012415L,38041165L,38041251L,38041195L,38041297L,38015857L,38041067L,38068827L,38068107L,38069435L,38068703L,38069369L,38069721L,38069155L,38068547L,38081091L,38081271L,38081445L,38080563L,38079551L,38081399L,38081961L,38082239L,38082243L,38082029L,38082265L,32167242L,38081483L,38082413L,38082673L,38102693L,38101885L,38102579L,38101457L,38102483L,38101435L,38103063L,38100939L,38103903L,38103633L,38104273L,38104511L,38104813L,38104911L,38201071L,38200771L,38201161L,38200859L,38201349L,38201353L,38201299L,38201459L,38201357L,38201507L,38201611L,38201455L,38201909L,38201505L,38201999L,38201703L,37473435L,38201755L,38201931L,38202171L,38202185L,38226967L,38227201L,36843862L,38226555L,38227165L,38226575L,38227433L,38227441L,38227449L,32287860L,38226571L,38226355L,37849645L,38227477L,38226943L,38227911L,38227917L,38225549L,38227841L,38227071L,38227759L,38227679L,38227737L,37638381L,38196555L,38228171L,38227879L,36212074L,38228319L,38228373L,38227877L,38228173L,37587393L,38228469L,38240319L,38239357L,38240241L,38236493L,38240457L,38239305L,38240793L,38238641L,38240383L,38240423L,25421980L,38241319L,38241423L,38240615L,38241413L,38240499L,38241977L,38240689L,38242173L,38241917L,36066020L,22051792L,38243405L,38242841L,38243005L,38243245L,38242717L,38243903L,38244173L,38243937L,38244055L,38244409L,38243745L,38245153L,38245159L,38242857L,38244841L,38245253L,38245039L,38243429L,38254321L,38254915L,38243487L,36945118L,38254949L,38255283L,38253895L,38255125L,36528954L,38255267L,37204866L,38255303L,38104893L,38255355L,38255029L,38255493L,38255223L,38245023L,38125625L,38191865L,38240589L,38252157L,38256203L,38255369L,38252975L,38256315L,38256461L,38256557L,38256477L,38255953L,38256329L,38255961L,38256617L,38256061L,38242599L,38256771L,38256585L,35456906L,38255813L,38256953L,38257007L,38256559L,38256385L,38257057L,38256209L,38257081L,38256649L,38256837L,38257265L,38257253L,37231876L,38254961L,38257317L,38257305L,38256293L,38255443L,38257375L,38256497L,38256457L,38257399L,38257431L,38210327L,38254825L,38257179L,38257483L,38257539L,38257567L,38256965L,38257593L,38257627L,38257373L,38257653L,38257497L,38257191L,38257295L,38257781L,38256991L,38236027L,35889224L,38257723L,38257229L,38256887L,37430749L,38257879L,38243587L,38257027L,38257441L,38257277L,38257975L,38257981L,38257991L,38258049L,38258101L,38257819L,38258115L,38257575L,38258033L,38258221L,38258235L,38258247L,38258241L,38257859L,38258273L,38258325L,38258349L,37335046L,38258445L,38258463L,38257911L,38252611L,38258149L,38257945L,38258603L,38258619L,38257977L,38258473L,38258703L,38382987L,38383077L,38382189L,38382793L,38382521L,38383151L,38382881L,38383311L,38383385L,38383127L,38383401L,37899957L,38383579L,38383703L,38383563L,38382359L,38383679L,38383695L,38382903L,38383603L,38363827L,38383815L,38384281L,38383171L,38384025L,38384019L,38384147L,38383969L,38302513L,38383233L,38383827L,38384321L,38384519L,38384557L,38384615L,38384805L,38384595L,38384433L,38384931L,5673929L));
        for(Long loan: loanList){
            iApiCommonService.queryData(loan,null);
        }
    }

    @Test
    public void testUpdateData(){
        iApiCommonService.updateBatchStatus(new Date(), CompensationStatus.already_status.get());
    }

    @Test
    public void testUpdateMerchantContractNo(){
        //HT100000201611250020530
        Integer row = iApiCommonService.updateMerchantContractNo("HT100000201611250020530",32618252L);
        logger.info("update row={}",row);
    }

}
