/*
Navicat MySQL Data Transfer

Source Server         : local
Source Server Version : 50717
Source Host           : localhost:3306
Source Database       : financial_system_api

Target Server Type    : MYSQL
Target Server Version : 50717
File Encoding         : 65001

Date: 2017-01-10 11:58:01
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for paymentdetail
-- ----------------------------
CREATE TABLE `paymentdetail` (
`id`  bigint(20) NOT NULL AUTO_INCREMENT ,
`userId`  bigint(20) NOT NULL ,
`userName`  varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL ,
`userPhoneNo`  varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL ,
`userIdNo`  varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL ,
`userIdType`  tinyint(4) NOT NULL ,
`loanHistoryId`  bigint(20) NOT NULL ,
`loanManifestHistoryId`  bigint(20) NOT NULL ,
`merchantContractNo`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL ,
`fundingCorpName`  varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL ,
`fundingCorpId`  bigint(20) NULL DEFAULT NULL ,
`paymentCorpName`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL ,
`paymentCorpId`  bigint(20) NULL DEFAULT NULL ,
`totalPrincipal`  decimal(20,2) NOT NULL ,
`loanPaidAt`  datetime NOT NULL ,
`loanCreateAt`  datetime NOT NULL ,
`contractTotalTerm`  int(11) NOT NULL ,
`createTime`  datetime NOT NULL ,
`updateTime`  datetime NOT NULL ,
PRIMARY KEY (`id`),
UNIQUE INDEX `idx_loanHistoryId` (`loanHistoryId`) USING BTREE ,
INDEX `idx_userId` (`userId`) USING BTREE ,
INDEX `idx_userPhoneNo` (`userPhoneNo`) USING BTREE
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8mb4 COLLATE=utf8mb4_general_ci
AUTO_INCREMENT=5

;

-- ----------------------------
-- Records of paymentdetail
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for repaymentplandetail
-- ----------------------------
CREATE TABLE `repaymentplandetail` (
`id`  bigint(20) NOT NULL AUTO_INCREMENT ,
`loanHistoryId`  bigint(20) NOT NULL ,
`repaymentPlanId`  bigint(20) NOT NULL ,
`currentTerm`  int(11) NOT NULL ,
`deadLine`  datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP ,
`principal`  decimal(20,2) NOT NULL ,
`interest`  decimal(20,2) NOT NULL DEFAULT 0.00 ,
`lhpServiceFee`  decimal(20,2) NOT NULL DEFAULT 0.00 ,
`fundingServiceFee`  decimal(20,2) NOT NULL DEFAULT 0.00 ,
`discount`  decimal(20,2) NOT NULL DEFAULT 0.00 ,
`discountType`  varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL ,
`compensationStatus`  tinyint(4) NOT NULL DEFAULT 0 COMMENT '0未代偿 1已代偿' ,
`compensationDate`  datetime NOT NULL COMMENT '代偿日' ,
`createTime`  datetime NOT NULL ,
`updateTime`  datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP ,
PRIMARY KEY (`id`),
UNIQUE INDEX `idx_loan_plan` (`loanHistoryId`, `repaymentPlanId`) USING BTREE ,
INDEX `idx_plan` (`repaymentPlanId`) USING BTREE
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8mb4 COLLATE=utf8mb4_general_ci
AUTO_INCREMENT=4

;

-- ----------------------------
-- Records of repaymentplandetail
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Auto increment value for paymentdetail
-- ----------------------------
ALTER TABLE `paymentdetail` AUTO_INCREMENT=5;

-- ----------------------------
-- Auto increment value for repaymentplandetail
-- ----------------------------
ALTER TABLE `repaymentplandetail` AUTO_INCREMENT=4;


ALTER TABLE `repaymentplandetail`
ADD INDEX `idx_compensation` (`compensationDate`) USING BTREE ;

ALTER TABLE `repaymentplandetail`
MODIFY COLUMN `deadLine`  datetime  AFTER `currentTerm`;


CREATE TABLE `fundingpaymentdetail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `loanHistoryId` bigint(20) NOT NULL COMMENT '贷款号 loan_application_history.loan_application_history_id',
  `loanManifestHistoryId` bigint(20) NOT NULL,
  `merchantContractNo` varchar(255) DEFAULT NULL COMMENT '合同号 contract.contract_no',
  `fundingRequestId` bigint(20) DEFAULT NULL COMMENT '借据号  waiting_funding_corp_operate_people.request_id',
  `fundingCorpLoanId` bigint(20) DEFAULT NULL COMMENT '资金方贷款号  waiting_funding_corp_operate_people.corp_loan_id',
  `userName` varchar(64) DEFAULT NULL COMMENT '姓名  user_detail.name',
  `userIdNo` varchar(32) DEFAULT NULL COMMENT '身份证号	',
  `loanAmount` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT '借款金额 loan_application_manifest_history.contract_loan_amount',
  `contractTotalTerm` int(11) DEFAULT NULL COMMENT '借款期数 loan_application_manifest_history.contract_term',
  `annualInterestRate` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT '年利率 loan_application_manifest_history.annual_interest_rate',
  `loanPaidAt` datetime DEFAULT NULL COMMENT '放款日期	loan_application_manifest_history.loan_paid_at',
  `affirmLoanPaidAt` datetime NOT NULL COMMENT '确认放款时间',
  `dataType` tinyint(4) DEFAULT '0' COMMENT '数据类型 资金方 0',
  `createTime` datetime DEFAULT NULL,
  `updateTime` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_loanHistoryId` (`loanHistoryId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


CREATE TABLE `fundingrepaymentplan` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `loanHistoryId` bigint(20) NOT NULL COMMENT 'loan_application_history.loan_application_history_id',
  `repaymentPlanId` bigint(20) NOT NULL COMMENT '还款计划id',
  `currentTerm` int(11) DEFAULT NULL,
  `deadLine` datetime DEFAULT NULL COMMENT '应还日期',
  `totalRepayAmount` decimal(20,6) DEFAULT '0.000000' COMMENT '应还合计',
  `repayPrincipal` decimal(20,6) DEFAULT '0.000000' COMMENT '应还本金',
  `repayInterest` decimal(20,6) DEFAULT '0.000000' COMMENT '应还利息',
  `lhpServiceFee` decimal(20,6) DEFAULT '0.000000' COMMENT '量化派服务费',
  `fundingServiceFee` decimal(20,6) DEFAULT '0.000000' COMMENT '资金方服务费',
  `fundingOverdueInterest` decimal(20,6) DEFAULT '0.000000' COMMENT '资金方逾期费',
  `lhpOverdueInterest` decimal(20,6) DEFAULT '0.000000' COMMENT '量化派逾期费',
  `alreadyTotalRepayAmount` decimal(20,6) DEFAULT '0.000000' COMMENT '实际还款合计',
  `alreadyRepayPrincipal` decimal(20,6) DEFAULT '0.000000' COMMENT '实际还款本金',
  `alreadyRepayInterest` decimal(20,6) DEFAULT '0.000000' COMMENT '实际还款利息',
  `alreadyLhpServiceFee` decimal(20,6) DEFAULT '0.000000' COMMENT '实际还量化派服务费',
  `alreadyFundingServiceFee` decimal(20,6) DEFAULT '0.000000' COMMENT '实际还资金方服务费',
  `alreadyHandlingCharge` decimal(20,6) DEFAULT '0.000000' COMMENT '实还手续费',
  `alreadyFundingOverduInterest` decimal(20,6) DEFAULT '0.000000' COMMENT '已还资金方逾期费',
  `alreadyLhpOverdueInterest` decimal(20,6) DEFAULT '0.000000' COMMENT '已还量化派逾期费',
  `status` tinyint(4) DEFAULT '0',
  `status2` tinyint(4) DEFAULT '0',
  `status3` tinyint(4) DEFAULT '0',
  `deleted` tinyint(4) DEFAULT '0' COMMENT '删除状态 0 未删除 -1已删除',
  `createTime` datetime DEFAULT NULL,
  `updateTime` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_loanHistoryId` (`loanHistoryId`) USING BTREE,
  KEY `idx_planId` (`repaymentPlanId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


ALTER TABLE `fundingrepaymentplan`
DROP COLUMN `repaymentPlanId`,
DROP INDEX `idx_planId`;

ALTER TABLE `fundingpaymentdetail`
ADD COLUMN `fundingCorpId`  bigint(20) NULL COMMENT '资金方id' AFTER `fundingCorpLoanId`;

-----150720
ALTER TABLE `pay_xyqb_detail`
ADD INDEX `idx_loanhistoryid` (`loan_application_history_id`) USING BTREE ,
ADD INDEX `idx_loanmanifest_id` (`loan_application_manifest_history_id`) USING BTREE ;

-----1134943
ALTER TABLE `repay_baitiao_detail`
ADD INDEX `idx_merchant_order_no` (`merchant_order_no`) USING BTREE ,
ADD INDEX `idx_order_id` (`order_id`) USING BTREE ;

----1720020
ALTER TABLE `repay_xyqb_detail`
ADD INDEX `idx_loan_application_manifest_history_id` (`loan_application_manifest_history_id`) USING BTREE ,
ADD INDEX `idx_loan_application_history_id` (`loan_application_history_id`) USING BTREE ;


CREATE TABLE `hubeidocname` (
`id`  bigint(20) NOT NULL AUTO_INCREMENT ,
`docName`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL ,
`dataType`  tinyint(4) NULL DEFAULT NULL ,
`deleted`  tinyint(2) NULL DEFAULT 0 ,
`ecCode`  varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '请求结果状态码' ,
`emMsg`  varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '请求结果' ,
`createTime`  datetime NULL DEFAULT NULL ,
`updateTime`  datetime NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP ,
PRIMARY KEY (`id`),
INDEX `idx_creatTime` (`createTime`) USING BTREE
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE `hubeihistory` (
`id`  bigint(20) NOT NULL AUTO_INCREMENT ,
`flowNo`  varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流水号' ,
`contactNo`  varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商户合同号' ,
`userId`  bigint(20) NULL DEFAULT NULL COMMENT '用户id' ,
`userName`  varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户名' ,
`userIdNo`  varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证件号' ,
`userIdType`  tinyint(4) NULL DEFAULT NULL COMMENT '证件类型' ,
`docNameId`  bigint(20) NULL DEFAULT NULL COMMENT '文件名' ,
`data`  text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '把传过来的数据存储' ,
`dataType`  tinyint(4) NULL DEFAULT NULL COMMENT '数据类型' ,
`currTermNo`  tinyint(4) NULL DEFAULT 0 COMMENT '当前期数' ,
`happenTime`  datetime NULL DEFAULT NULL COMMENT '操作发生时间' ,
`createTime`  datetime NULL DEFAULT NULL COMMENT '创建时间' ,
`updateTime`  datetime NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '记录更新时间' ,
`deleted`  tinyint(2) NULL DEFAULT 0 COMMENT '删除状态0 正常 1被删除' ,
`seqNo`  tinyint(2) NULL DEFAULT 1 ,
PRIMARY KEY (`id`),
INDEX `idx_contactNo` (`contactNo`) USING BTREE ,
INDEX `idx_userId` (`userId`) USING BTREE ,
INDEX `idx_userIdNo` (`userIdNo`) USING BTREE ,
INDEX `idx_happenTime` (`happenTime`) USING BTREE
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `mailinfo` (
`id`  bigint(20) NOT NULL AUTO_INCREMENT ,
`mail`  varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`mailType`  tinyint(2) NULL DEFAULT NULL ,
`createTime`  datetime NULL DEFAULT NULL ,
`updateTime`  datetime NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP ,
PRIMARY KEY (`id`),
INDEX `idx_mail` (`mail`) USING BTREE
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=3

;



