package cn.quantgroup.financial.service;

import cn.quantgroup.financial.exception.ArgsInvaildException;
import cn.quantgroup.financial.exception.FieldInsufficientException;
import cn.quantgroup.financial.model.PaymentDetail;
import cn.quantgroup.financial.model.RepaymentPlanStatus;

import java.util.Date;
import java.util.List;

/**
 * Created by WuKong on 2017/1/6.
 */
public interface IApiCommonService {

    List<RepaymentPlanStatus> getRepaymentPlanStatus(Long loanHistoryId, Long repaymentPlanId) throws ArgsInvaildException;
    Integer savePaymentDetailAndRepaymentPlan(PaymentDetail paymentDetail) throws FieldInsufficientException;
    PaymentDetail queryData(Long loanHistoryId, Long repaymentPlanId);
    Integer updateBatchStatus(Date beforeDate, Byte compensationStatus);
    Integer updateMerchantContractNo(String contractNo,Long loanHistoryId);
}
