package cn.quantgroup.financial.model;

import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class RepaymentPlanDetail implements Serializable{

    private Long id;
    //借款id
    private Long loanHistoryId;
    //还款计划id
    private Long repaymentPlanId;
    //当前期数
    private Integer currentTerm;
    //还款截止时间
    private Date deadLine;
    //本金
    private BigDecimal principal;
    //利息
    private BigDecimal interest;
    //量化派服务费
    private BigDecimal lhpServiceFee;
    //资金方服务费
    private BigDecimal fundingServiceFee;
    //活动减免
    private BigDecimal discount;
    //减免类型
    private String discountType;
    //代偿状态值 0 未代偿 1已代偿
    private Byte compensationStatus;
    //代偿日
    private Date compensationDate;

    private Date createTime;

    private Date updateTime;


    //要求不为空的字段名
    @JSONField(serialize=false)
    public static List<String> notNullField = new ArrayList<>(Arrays.asList("loanHistoryId", "repaymentPlanId", "currentTerm","deadLine","principal"));

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getLoanHistoryId() {
        return loanHistoryId;
    }

    public void setLoanHistoryId(Long loanHistoryId) {
        this.loanHistoryId = loanHistoryId;
    }

    public Long getRepaymentPlanId() {
        return repaymentPlanId;
    }

    public void setRepaymentPlanId(Long repaymentPlanId) {
        this.repaymentPlanId = repaymentPlanId;
    }

    public Integer getCurrentTerm() {
        return currentTerm;
    }

    public void setCurrentTerm(Integer currentTerm) {
        this.currentTerm = currentTerm;
    }

    public Date getDeadLine() {
        return deadLine;
    }

    public void setDeadLine(Date deadLine) {
        this.deadLine = deadLine;
    }

    public BigDecimal getPrincipal() {
        return principal;
    }

    public void setPrincipal(BigDecimal principal) {
        this.principal = principal;
    }

    public BigDecimal getInterest() {
        return interest;
    }

    public void setInterest(BigDecimal interest) {
        this.interest = interest;
    }

    public BigDecimal getLhpServiceFee() {
        return lhpServiceFee;
    }

    public void setLhpServiceFee(BigDecimal lhpServiceFee) {
        this.lhpServiceFee = lhpServiceFee;
    }

    public BigDecimal getFundingServiceFee() {
        return fundingServiceFee;
    }

    public void setFundingServiceFee(BigDecimal fundingServiceFee) {
        this.fundingServiceFee = fundingServiceFee;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public String getDiscountType() {
        return discountType;
    }

    public void setDiscountType(String discountType) {
        this.discountType = discountType == null ? null : discountType.trim();
    }

    public Byte getCompensationStatus() {
        return compensationStatus;
    }

    public void setCompensationStatus(Byte compensationStatus) {
        this.compensationStatus = compensationStatus;
    }

    public Date getCompensationDate() {
        return compensationDate;
    }

    public void setCompensationDate(Date compensationDate) {
        this.compensationDate = compensationDate;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public String toString() {
        return "RepaymentPlanDetail{" +
                "id=" + id +
                ", loanHistoryId=" + loanHistoryId +
                ", repaymentPlanId=" + repaymentPlanId +
                ", currentTerm=" + currentTerm +
                ", deadLine=" + deadLine +
                ", principal=" + principal +
                ", interest=" + interest +
                ", lhpServiceFee=" + lhpServiceFee +
                ", fundingServiceFee=" + fundingServiceFee +
                ", discount=" + discount +
                ", discountType='" + discountType + '\'' +
                ", compensationStatus=" + compensationStatus +
                ", compensationDate=" + compensationDate +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                '}';
    }
}