package cn.quantgroup.financial.json;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

/**
 * 
 * @author dave
 *
 */
public class JsonResponseMethodReturnValueHandler implements HandlerMethodReturnValueHandler {

    /**
     * Logger for this class
     */
    private static final Logger logger = LoggerFactory.getLogger(JsonResponseMethodReturnValueHandler.class);

    private static final String DEFAULT_VIEW_NAME = "jsonView";

    public static final String JR_MODEL_KEY = JsonResponse.class.getName() + "-instance";

    private String viewName = DEFAULT_VIEW_NAME;

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return JsonResponse.class.isAssignableFrom(returnType.getParameterType());
    }

    @Override
    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer,
            NativeWebRequest webRequest) throws Exception {
        if (returnValue == null) {
            return;
        }

        mavContainer.setViewName(viewName);

        if (!(returnValue instanceof JsonResponse)) {
            // should not happen
            throw new UnsupportedOperationException("Unexpected return type: "
                    + returnType.getParameterType().getName() + " in method: " + returnType.getMethod());
        }
        JsonResponse jsonResponse = (JsonResponse) returnValue;

        mavContainer.getModel().clear();
        mavContainer.addAttribute(JR_MODEL_KEY, jsonResponse);
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }
}
