package cn.quantgroup.financial.dao;

import cn.quantgroup.financial.aspect.data.DataSourceConfig;
import cn.quantgroup.financial.constant.DataBaseType;
import cn.quantgroup.financial.model.RepayXyqbDetail;

import java.util.Date;
import java.util.List;

/**
 * Created by WuKong on 2017/1/23.
 */
@DataSourceConfig(DataBaseType.System_DB)
public interface IRepayRecordDao {
    /**
     * 通过还款时间间隔以及资金方id查询 还款信息
     * @param fundingCorpId
     * @param beforeTime
     * @param afterTime
     * @return
     */
    List<RepayXyqbDetail> getRepayXyqbDetailList(Long fundingCorpId, Date beforeTime, Date afterTime);

    List<RepayXyqbDetail> getListByLoanHistroyIds(Long fundingCorpId,List<Long> loanHistoryIdList);
    /**
     * 排除loanId list之后 时间段内的某一资金方 还款记录
     * @param fundingCorpId
     * @param loanHistoryIdList
     * @param gtDate
     * @param ltDate
     * @return
     */
    List<RepayXyqbDetail> getListNotLoanIdBetweenDate(Long fundingCorpId,List<Long> loanHistoryIdList,Date gtDate,Date ltDate);
}
