package cn.quantgroup.financial.util;

import org.dom4j.DocumentException;
import org.junit.Test;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by WuKong on 2017/1/18.
 */
public class HubeiCFCUtilTest {


    @Test
    public void testBuildRequest(){
        Map<String,String> argsMap = new HashMap<String,String>(){
            {
                put("applyDt","22334343");
                put("flag","dldl");
            }
        };
        try {
            String xml = HubeiCFCUtil.buildRequest(argsMap,"CF004052");
            System.out.println(xml);
        } catch (ParserConfigurationException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (TransformerException e) {
            e.printStackTrace();
        }
    }
    @Test
    public void testParseResponse(){

        String response = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n" +
                "<root>\n" +
                "\t<ec>0</ec>\n" +
                "\t<em></em>\n" +
                "<Resp>\n" +
                "\t\t<applCde>1002201610171002704</applCde>\n" +
                "\t\t<cstno>19285473</cstno>\n" +
                "\t\t<docName>01</docName>\n" +
                "\t\t<loanTyp>PXFD002</loanTyp>\n" +
                "\t\t<picUploadFile>0dddddddddddddddd1</picUploadFile>\n" +
                "\t\t<iSavings>\n" +
                "\t\t\t<rows>\n" +
                "\t\t\t\t<accountKey>54743</accountKey>\n" +
                "\t\t\t\t<accountNo>6225********1234</accountNo>\n" +
                "\t\t\t\t<alias>工资卡</alias>\n" +
                "\t\t\t\t<field id=\"openBank\" value=\"总行营业部\" />\n" +
                "\t\t\t</rows>\n" +
                "\t\t\t<rows>\n" +
                "\t\t\t\t<accountKey>47399</accountKey>\n" +
                "\t\t\t\t<accountNo>6225********3743</accountNo>\n" +
                "\t\t\t\t<alias>一卡通</alias>\n" +
                "\t\t\t\t<openBank>天津分行海光寺支行</openBank>\n" +
                "\t\t\t</rows>\n" +
                "\t\t\t<rows>\n" +
                "\t\t\t\t<accountKey>28510</accountKey>\n" +
                "\t\t\t\t<accountNo>4367********8078</accountNo>\n" +
                "\t\t\t\t<alias>公积金</alias>\n" +
                "\t\t\t\t<openBank>北京分行和平里支行</openBank>\n" +
                "\t\t\t</rows>\n" +
                "\t\t</iSavings>\n" +
                "</Resp>" +
                "</root>\n";

        try {
            HubeiCFCUtil.parseDiscResponse(org.apache.commons.io.IOUtils.toInputStream(response,Charset.forName("utf-8")));
        } catch (IOException e) {
            e.printStackTrace();
        } catch (SAXException e) {
            e.printStackTrace();
        } catch (ParserConfigurationException e) {
            e.printStackTrace();
        } catch (DocumentException e) {
            e.printStackTrace();
        }

    }
}
