package cn.quantgroup.financial.service;

import cn.quantgroup.financial.BootStarter;
import cn.quantgroup.financial.constant.CompensationStatus;
import cn.quantgroup.financial.exception.ArgsInvaildException;
import cn.quantgroup.financial.exception.FieldInsufficientException;
import cn.quantgroup.financial.model.PaymentDetail;
import cn.quantgroup.financial.model.RepaymentPlanStatus;
import com.alibaba.fastjson.JSON;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.SpringApplicationConfiguration;
import org.springframework.core.env.Environment;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * Created by WuKong on 2017/1/9.
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringApplicationConfiguration(classes = BootStarter.class)
@WebAppConfiguration
@ActiveProfiles("test")
public class ApiCommonServiceTest {

    @Autowired
    Environment env;
    @Autowired
    IApiCommonService iApiCommonService;

    private static Logger logger = LoggerFactory.getLogger(ApiCommonServiceTest.class);

    @Test
    public void testGetRepaymentPlanStatus(){
        try {
            List<RepaymentPlanStatus> repaymentPlanStatusList = iApiCommonService.getRepaymentPlanStatus(40201007L,null);
            logger.info("json={}",JSON.toJSONString(repaymentPlanStatusList));
        } catch (ArgsInvaildException e) {
            logger.error(e.getMessage(),e);
        }
    }

    @Test
    public void testSavePaymentDetailAndRepaymentPlan(){
        String json = "{\n" +
                "  \"paymentCorpName\": \"湖北消金\",\n" +
                "  \"userIdType\": 0,\n" +
                "  \"repaymentPlanDetailList\": [\n" +
                "    {\n" +
                "      \"principal\": 1980.13,\n" +
                "      \"currentTerm\": 1,\n" +
                "      \"fundingServiceFee\": 0,\n" +
                "      \"interest\": 60.00,\n" +
                "      \"lhpServiceFee\": 180,\n" +
                "      \"repaymentPlanId\": 101,\n" +
                "      \"discountType\": \"\",\n" +
                "      \"deadLine\": \"2016-03-30\"\n" +
                "    },\n" +
                "    {\n" +
                "      \"principal\": 1999.93,\n" +
                "      \"currentTerm\": 2,\n" +
                "      \"fundingServiceFee\": 0,\n" +
                "      \"interest\": 40.20,\n" +
                "      \"lhpServiceFee\": 180,\n" +
                "      \"repaymentPlanId\": 102,\n" +
                "      \"discountType\": \"\",\n" +
                "      \"deadLine\": \"2016-04-29\"\n" +
                "    },\n" +
                "    {\n" +
                "      \"principal\": 2019.93,\n" +
                "      \"currentTerm\": 3,\n" +
                "      \"fundingServiceFee\": 0,\n" +
                "      \"interest\": 20.20,\n" +
                "      \"lhpServiceFee\": 180,\n" +
                "      \"repaymentPlanId\": 103,\n" +
                "      \"discountType\": \"\",\n" +
                "      \"deadLine\": \"2016-05-30\"\n" +
                "    }\n" +
                "  ],\n" +
                "  \"userPhoneNo\": \"18000000000\",\n" +
                "  \"totalPrincipal\": 6000,\n" +
                "  \"fundingCorpName\": \"湖北消金\",\n" +
                "  \"userName\": \"测试\",\n" +
                "  \"userId\": 1001,\n" +
                "  \"loanCreateAt\": 1483945900051,\n" +
                "  \"loanHistoryId\": 3001,\n" +
                "  \"paymentCorpId\": 290,\n" +
                "  \"loanManifestHistoryId\": 2001,\n" +
                "  \"fundingCorpId\": 290,\n" +
                "  \"loanPaidAt\": 1483945900051,\n" +
                "  \"userIdNo\": \"100000000000000000\",\n" +
                "  \"contractTotalTerm\": 3\n" +
                "}";
        PaymentDetail paymentDetail = JSON.parseObject(json, PaymentDetail.class);
        try {
            iApiCommonService.savePaymentDetailAndRepaymentPlan(paymentDetail);
        } catch (FieldInsufficientException e) {
            logger.error(e.getMessage(),e);
        }
    }

    @Test
    public void testQueryData(){

        List<Long> loanList = new ArrayList<>(Arrays.asList(40201007L));
        for(Long loan: loanList){
            iApiCommonService.queryData(loan,null);
        }
    }

    @Test
    public void testUpdateData(){
        iApiCommonService.updateBatchStatus(new Date(), CompensationStatus.already_status.get());
    }

    @Test
    public void testUpdateMerchantContractNo(){
        //HT100000201611250020530
        Integer row = iApiCommonService.updateMerchantContractNo("HT100000201611250020530",32618252L);
        logger.info("update row={}",row);
    }

}
