package cn.quantgroup.financial.init;

import cn.quantgroup.financial.service.sys.ICompensationDayService;
import cn.quantgroup.financial.service.sys.IScheduledJudgeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

/**
 * Created by WuKong on 2017/1/10.
 */
@Component
public class InitRunner implements CommandLineRunner {

    private static final Logger logger = LoggerFactory.getLogger(InitRunner.class);
    @Autowired
    private ICompensationDayService compensationDayService;

    @Autowired
    private IScheduledJudgeService scheduledJudgeService;

    @Override
    public void run(String... strings) throws Exception {
        logger.info("start prepare compenstationDaysData ");
        compensationDayService.prepareCompenstationDaysData();
        logger.info("end prepare compenstationDaysData ");
        if(scheduledJudgeService.isOpenScheduled()){
            logger.error("finance api config-------------------scheduled task is opened");
        }else {
            logger.error("finance api config-------------------scheduled task is closed");
        }

        if(scheduledJudgeService.isOpenHuBeiRequest()){
            logger.error("finance api config-------------------HuBei push request is opened");
        }else {
            logger.error("finance api config-------------------HuBei push request is closed");
        }

    }
}
