package cn.quantgroup.financial.handler.hubei.impl;

import cn.quantgroup.financial.constant.HubeiCFCDataType;
import cn.quantgroup.financial.constant.SysConstant;
import cn.quantgroup.financial.handler.hubei.HubeiContentHandler;
import cn.quantgroup.financial.model.huibeicfc.HuBeiHistory;
import cn.quantgroup.financial.model.huibeicfc.HuBeiJsonBean;
import cn.quantgroup.financial.util.HubeiCFCUtil;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 提前还款校验
 * Created by WuKong on 2017/1/19.
 */
@Service
public class SendCheckHandler implements HubeiContentHandler {

    @Override
    public HuBeiHistory parse(String line) {

        String[] args =  line.split(SysConstant.verticalRegx);
        HuBeiHistory history = new HuBeiHistory();
        int index =0;
        history.setContactNo(args[index++]);
        history.setUserName(args[index++]);
        history.setUserIdType(HubeiCFCUtil.getIDType(args[index++]));
        history.setUserIdNo(args[index++]);
        history.setDataType(getType().get());

        HuBeiJsonBean jsonBean = new HuBeiJsonBean();
        HubeiCFCUtil.copy(history,jsonBean);
        jsonBean.setRepayType(args[index++]);
        jsonBean.setRepayDate(args[index++]);
        jsonBean.setShortenTerm(Integer.valueOf(args[index++]));
        jsonBean.setRepayTotalAmount(new BigDecimal(args[index++]));
        jsonBean.setChannel(args[index++]);
        jsonBean.setApplyRepayDate(args[index++]);
        jsonBean.setTradeCode(args[index++]);
        jsonBean.setTradeMsg(args[index++]);
        history.setData(jsonBean);
        return history;
    }

    @Override
    public HubeiCFCDataType getType() {
        return HubeiCFCDataType.SEND_ADVANCE_REPAYMENT_CHECK;
    }

    @Override
    public String builder(HuBeiHistory huBeiHistory) {
        return new StringBuilder(huBeiHistory.getContactNo())
                .append(SysConstant.vertical).append(huBeiHistory.getUserName())
                .append(SysConstant.vertical).append(HubeiCFCUtil.getHuBeiType(huBeiHistory.getUserIdType()))
                .append(SysConstant.vertical).append(huBeiHistory.getUserIdNo())
                .append(SysConstant.vertical).append(huBeiHistory.getData().getRepayType())
                .append(SysConstant.vertical).append(huBeiHistory.getData().getRepayDate())
                .append(SysConstant.vertical).append(huBeiHistory.getData().getShortenTerm())
                .append(SysConstant.vertical).append(huBeiHistory.getData().getRepayTotalAmount().toString())
                .append(SysConstant.vertical).append(huBeiHistory.getData().getChannel())
                .append(SysConstant.vertical).append(huBeiHistory.getData().getApplyRepayDate())
                .append(SysConstant.vertical).append(huBeiHistory.getData().getTradeCode())
                .append(SysConstant.vertical).append(huBeiHistory.getData().getTradeMsg()).toString();
    }
}
