package cn.quantgroup.financial.handler.hubei.impl;

import cn.quantgroup.financial.constant.HubeiCFCDataType;
import cn.quantgroup.financial.constant.SysConstant;
import cn.quantgroup.financial.handler.hubei.HubeiContentHandler;
import cn.quantgroup.financial.model.huibeicfc.HuBeiHistory;
import cn.quantgroup.financial.model.huibeicfc.HuBeiJsonBean;
import cn.quantgroup.financial.util.HubeiCFCUtil;
import cn.quantgroup.financial.util.NumberUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * Created by WuKong on 2017/1/19.
 */
@Service
public class ReturnDebitHandler implements HubeiContentHandler {
    @Override
    public HuBeiHistory parse(String line) {
        String[] args =  line.split(SysConstant.verticalRegx);
        HuBeiHistory history = new HuBeiHistory();
        history.setFlowNo(args[0]);
        history.setContactNo(args[1]);
        history.setUserName(args[2]);
        history.setUserIdType(HubeiCFCUtil.getIDType(args[3]));
        history.setUserIdNo(args[4]);
        history.setDataType(getType().get());

        HuBeiJsonBean jsonBean = new HuBeiJsonBean();
        HubeiCFCUtil.copy(history,jsonBean);
        jsonBean.setRepayAmount(new BigDecimal(args[5]));
        jsonBean.setReallyRepayAmount(NumberUtils.getNotNull(args[6]));//没有则为0
        jsonBean.setTradeCode(args[7]);
        jsonBean.setTradeMsg(args[8]);
        history.setData(jsonBean);
        return history;
    }

    @Override
    public HubeiCFCDataType getType() {
        return HubeiCFCDataType.RETURN_BATCH_DEBIT;
    }

    @Override
    public String builder(HuBeiHistory huBeiHistory) {
        return new StringBuilder(huBeiHistory.getFlowNo())
                .append(SysConstant.vertical).append(huBeiHistory.getContactNo())
                .append(SysConstant.vertical).append(huBeiHistory.getUserName())
                .append(SysConstant.vertical).append(HubeiCFCUtil.getHuBeiType(huBeiHistory.getUserIdType()))
                .append(SysConstant.vertical).append(huBeiHistory.getUserIdNo())
                .append(SysConstant.vertical).append(huBeiHistory.getData().getRepayAmount().toString())
                .append(SysConstant.vertical).append(huBeiHistory.getData().getReallyRepayAmount().toString())
                .append(SysConstant.vertical).append(huBeiHistory.getData().getTradeCode())
                .append(SysConstant.vertical).append(huBeiHistory.getData().getTradeMsg()).toString();
    }
}
