package cn.quantgroup.financial.service.sys;

import cn.quantgroup.financial.model.MailInfo;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.MimeMessagePreparator;

import javax.activation.DataSource;
import javax.mail.internet.MimeMessage;
import java.io.InputStream;
import java.util.ArrayList;

public interface IMailService {

    void sendAttachmentMailAsync(String from, String sendTo, String ccTo, String subject, String text,
                                 ArrayList<String> attachedFileList, IMailSendCallback mailSendCallback);
    void sendAttachmentMailAsync(String from, String[] sendTo, String[] ccTo, String subject, String text,
                                 ArrayList<String> attachedFileList, IMailSendCallback mailSendCallback);

    void sendAttachmentMailWithBytesAsync(String from,String sendTo,String ccTo,String subject,String text,
                                          ArrayList<DataSource> attachedBytes ,IMailSendCallback mailSendCallback);

    void sendAttachmentMailWithBytesAsync(String from,String[] sendTo,String[] ccTo,String subject,String text,
                                          ArrayList<DataSource> attachedBytes ,IMailSendCallback mailSendCallback);

    void sendSimpleMailAsync(String from, String sendTo, String ccTo, String subject, String text);
    void sendSimpleMailAsync(String from, String[] sendTo, String[] ccTo, String subject, String text);

    void sendMailAsync(SimpleMailMessage[] simpleMailMessages, IMailSendCallback... callbacks);

    void sendMailAsync(SimpleMailMessage simpleMailMessage, IMailSendCallback... callbacks);

    void sendMailAsync(MimeMessage mimeMessage, IMailSendCallback... callbacks);

    void sendMailAsync(MimeMessage[] mimeMessages, IMailSendCallback... callbacks);

    void sendMailAsync(MimeMessagePreparator message, IMailSendCallback... callbacks);

    void sendMailAsync(MimeMessagePreparator[] messages, IMailSendCallback... callbacks);

    void sendMail(SimpleMailMessage... simpleMailMessages);

    void sendMail(SimpleMailMessage simpleMailMessage);

    void sendMail(MimeMessage mimeMessage);

    void sendMail(MimeMessage... mimeMessages);

    void sendMail(MimeMessagePreparator message);

    void sendMail(MimeMessagePreparator... messages);
    void sendSimpleMail(SimpleMailMessage message);

    void sendMailQuietly(SimpleMailMessage... simpleMailMessages);

    void sendMailQuietly(SimpleMailMessage simpleMailMessage);

    void sendMailQuietly(MimeMessage mimeMessage);

    void sendMailQuietly(MimeMessage... mimeMessages);

    void sendMailQuietly(MimeMessagePreparator message);

    void sendMailQuietly(MimeMessagePreparator... messages);

    MimeMessage createMimeMessage();

    MimeMessage createMimeMessage(InputStream var1) throws MailException;

    DataSource getDataSource(String content,String fileName);

    Long saveMailInfo(MailInfo mailInfo);

    Integer deleteMailInfo(Long id);
}
