package cn.quantgroup.financial.service.sys;

import java.util.Calendar;
import java.util.Date;

/**
 * 维护代偿日
 * Created by WuKong on 2017/1/6.
 */
public interface ICompensationDayService {

    /**
     * 当天是否为代偿日
     * @return
     */
    boolean isCompensationDay();


    boolean isCompensationDay(Calendar calendar);

    /**
     * 通过月查询代偿日
     * @param month 1-12
     * @return
     */
    Date getCompensationDay(Integer year, Integer month);

    /**
     * 通过传入date计算代偿日
     * @param date
     * @return
     */
    Date computeCompenstationDay(Date date);
    /**
     * 初始化数据
     * @throws Exception
     */
    void prepareCompenstationDaysData() throws Exception;
}
