package cn.quantgroup.financial.mapper;

import cn.quantgroup.financial.model.RepaymentPlanDetail;
import cn.quantgroup.financial.model.RepaymentPlanStatus;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

public interface RepaymentPlanDetailMapper {

    int insert(RepaymentPlanDetail record);

    int insertSelective(RepaymentPlanDetail record);

    RepaymentPlanDetail selectByPrimaryKey(Long id);

    int updateBatchCompensationStatusById(@Param("idList")List<Long> idList,@Param("compensationStatus") Byte compensationStatus);
    int updateBatchCompensationStatusBeforeDate(@Param("beforeDate") Date beforeDate,@Param("compensationStatus") Byte compensationStatus);
    int updateByPrimaryKeySelective(RepaymentPlanDetail record);
    int updateByPrimaryKey(RepaymentPlanDetail record);
    RepaymentPlanDetail getByLoanIdAndTerm(@Param("loanHistoryId") Long loanHistoryId,@Param("currentTerm") Integer currentTerm);
    List<Long> getIdListByCompensationDate(@Param("compensationDate") Date compensationDate);
    List<Long> getIdListByNotYetCompensation(@Param("compensationDate") Date compensationDate);
    List<RepaymentPlanDetail> getListByCompensationDateAndLoanIds(@Param("compensationDate") Date compensationDate,@Param("loanHistoryIdList") List<Long> loanHistoryIdList);
    List<RepaymentPlanStatus> getRepaymentPlanStatus(@Param("loanHistoryId") Long loanHistoryId, @Param("repaymentPlanId") Long repaymentPlanId);
    List<RepaymentPlanDetail> getRepaymentPlanListByLoanIds(@Param("loanHistoryIdList") List<Long> loanHistoryIdList);
    List<RepaymentPlanDetail> getListByLoanIdsAndCompensationStatus(@Param("loanHistoryIdList") List<Long> loanHistoryIdList,@Param("compensationStatus") Byte compensationStatus);
}