package cn.quantgroup.financial.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Created by WuKong on 2017/1/12.
 */
public class MD5Util {

    private static final Logger LOGGER = LoggerFactory.getLogger(MD5Util.class);

    public static String build(String content) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest
                    .getInstance("md5");
        } catch (NoSuchAlgorithmException e) {
            LOGGER.error(e.getMessage(), e);
            return null;
        }
        messageDigest.update(content.getBytes());
        byte[] domain = messageDigest.digest();
        StringBuffer md5StrBuff = new StringBuffer();
        // converting domain to String
        for (int i = 0; i < domain.length; i++) {
            if (Integer.toHexString(0xFF & domain[i]).length() == 1) {
                md5StrBuff.append("0").append(
                        Integer.toHexString(0xFF & domain[i]));
            } else
                md5StrBuff.append(Integer.toHexString(0xFF & domain[i]));
        }
        return md5StrBuff.toString();
    }

}
