package cn.quantgroup.financial.service.impl;

import cn.quantgroup.financial.constant.CompensationStatus;
import cn.quantgroup.financial.constant.EncodingConfig;
import cn.quantgroup.financial.constant.HubeiCFCField;
import cn.quantgroup.financial.dao.IPaymentDao;
import cn.quantgroup.financial.exception.ArgsInvaildException;
import cn.quantgroup.financial.exception.FieldInsufficientException;
import cn.quantgroup.financial.model.*;
import cn.quantgroup.financial.model.huibeicfc.HuBeiCFCResponse;
import cn.quantgroup.financial.service.IApiCommonService;
import cn.quantgroup.financial.service.http.IHttpService;
import cn.quantgroup.financial.service.sys.ICompensationDayService;
import cn.quantgroup.financial.util.*;
import com.alibaba.fastjson.JSON;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by WuKong on 2017/1/6.
 */
@Service
public class ApiCommonServiceImpl implements IApiCommonService {

    private static final Logger logger = LoggerFactory.getLogger(ApiCommonServiceImpl.class);
    @Autowired
    IPaymentDao iPaymentDao;

    @Autowired
    IHttpService httpService;

    @Autowired
    ICompensationDayService iCompensationDayService;

    @Value("${rapi.xyqb.plans}")
    private String queryPlansUrl;



    @Override
    public List<RepaymentPlanStatus> getRepaymentPlanStatus(Long loanHistoryId, Long repaymentPlanId) throws ArgsInvaildException {
        return iPaymentDao.getRepaymentPlanStatus(loanHistoryId,repaymentPlanId);
    }

    @Override
    public Integer savePaymentDetailAndRepaymentPlan(PaymentDetail paymentDetail) throws FieldInsufficientException {

        CheckUtil.assertFieldNotNull(paymentDetail,PaymentDetail.notNullField);
        for (RepaymentPlanDetail repaymentPlanDetail:paymentDetail.getRepaymentPlanDetailList()){
            repaymentPlanDetail.setLoanHistoryId(paymentDetail.getLoanHistoryId());
            //代偿日
            Date compensationDate = iCompensationDayService.computeCompenstationDay(repaymentPlanDetail.getDeadLine());
            if(compensationDate==null){
                logger.error("payDetailId ={}, planId={},deadline = {} compensationDate is null",paymentDetail.getId(),repaymentPlanDetail.getId(),repaymentPlanDetail.getDeadLine());
                //代偿日错误 先保存数据 后修复此值
                compensationDate = new Date();
            }
            repaymentPlanDetail.setCompensationDate(compensationDate);
            if(compensationDate.after(new Date())){
                repaymentPlanDetail.setCompensationStatus(CompensationStatus.noyet_status.get());
            }else {
                repaymentPlanDetail.setCompensationStatus(CompensationStatus.already_status.get());
            }
            repaymentPlanDetail.setCreateTime(new Date());
            repaymentPlanDetail.setUpdateTime(new Date());
            CheckUtil.assertFieldNotNull(repaymentPlanDetail,RepaymentPlanDetail.notNullField);
        }


        Integer row = iPaymentDao.savePaymentDetailAndRepaymentPlan(paymentDetail);
        return row;
    }

    @Override
    public PaymentDetail queryData(Long loanHistoryId, Long repaymentPlanId){
        logger.info("queryDate loanHistoryId={},repaymentPlanId={}",loanHistoryId,repaymentPlanId);
        try {
            if(loanHistoryId!=null){
                String response = httpService.get(queryPlansUrl+"?loanId="+loanHistoryId);
                if(!StringUtils.isEmpty(response)){
                    logger.info("response={}",response);
                    XyqbResult jsonResult = JSON.parseObject(response, XyqbResult.class);
                    if(jsonResult!=null&&jsonResult.getSuccess()!=null&&jsonResult.getSuccess()){
                        PaymentDetail paymentDetail = (PaymentDetail)jsonResult.getData();
                        try {
                            savePaymentDetailAndRepaymentPlan(paymentDetail);
                        } catch (FieldInsufficientException e) {
                            logger.error(e.getMessage(),e);
                        }
                        return paymentDetail;
                    }else {
                        logger.info("result is not success");
                    }
                }else {
                    logger.info("response is empty");
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }
        return null;
    }


    @Override
    public Integer updateBatchStatus(Date beforeDate,Byte compensationStatus){
        return iPaymentDao.updateBatchCompensationStatusBeforeDate(beforeDate,compensationStatus);
    }

    @Override
    public Integer updateBatchCompensationStatusById(List<Long> idList,Byte compensationStatus){
        return iPaymentDao.updateBatchCompensationStatusById(idList,compensationStatus);
    }

    @Override
    public Integer updateMerchantContractNo(String contractNo, Long loanHistoryId) {
        if(StringUtils.isEmpty(contractNo)||loanHistoryId==null){
            return 0;
        }
        return iPaymentDao.updateMerchantContractNo(contractNo,loanHistoryId);
    }

}
