package cn.quantgroup.financial.json;

import cn.quantgroup.financial.model.PaymentDetail;
import cn.quantgroup.financial.model.RepaymentPlanDetail;
import cn.quantgroup.financial.model.RepaymentPlanStatus;
import com.alibaba.fastjson.JSON;
import org.junit.Test;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by WuKong on 2017/1/6.
 */
public class TestJson {

    @Test
    public void testDateJson(){
        RepaymentPlanDetail repaymentPlanDetail = new RepaymentPlanDetail();
        repaymentPlanDetail.setUpdateTime(new Date());
        String json = JSON.toJSONString(repaymentPlanDetail);
        System.out.println(json);
        repaymentPlanDetail = JSON.parseObject(json,RepaymentPlanDetail.class);
        System.out.println(repaymentPlanDetail);
    }

    @Test
    public void testRepaymentPlanStatus(){
        RepaymentPlanStatus repaymentPlanStatus = new RepaymentPlanStatus();
        repaymentPlanStatus.setLoanHistoryId(3001l);
        System.out.println(JSON.toJSONString(repaymentPlanStatus));
    }

    @Test
    public void testList(){
        List<Long> loanIdlist = new ArrayList<>();
        loanIdlist.add(34920666L);
        loanIdlist.add(34920667L);
        String json = JSON.toJSONString(loanIdlist);
        System.out.println(json);
    }
    @Test
    public void testPaymentJson(){
        String json = "{\n" +
                "  \"paymentCorpName\": \"湖北消金\",\n" +
                "  \"userIdType\": 0,\n" +
                "  \"repaymentPlanDetailList\": [\n" +
                "    {\n" +
                "      \"principal\": 1980.13,\n" +
                "      \"currentTerm\": 1,\n" +
                "      \"fundingServiceFee\": 0,\n" +
                "      \"interest\": 60.00,\n" +
                "      \"lhpServiceFee\": 180,\n" +
                "      \"repaymentPlanId\": 101,\n" +
                "      \"discountType\": \"\",\n" +
                "      \"deadLine\": \"2016-03-30\"\n" +
                "    },\n" +
                "    {\n" +
                "      \"principal\": 1999.93,\n" +
                "      \"currentTerm\": 2,\n" +
                "      \"fundingServiceFee\": 0,\n" +
                "      \"interest\": 40.20,\n" +
                "      \"lhpServiceFee\": 180,\n" +
                "      \"repaymentPlanId\": 102,\n" +
                "      \"discountType\": \"\",\n" +
                "      \"deadLine\": \"2016-04-29\"\n" +
                "    },\n" +
                "    {\n" +
                "      \"principal\": 2019.93,\n" +
                "      \"currentTerm\": 3,\n" +
                "      \"fundingServiceFee\": 0,\n" +
                "      \"interest\": 20.20,\n" +
                "      \"lhpServiceFee\": 180,\n" +
                "      \"repaymentPlanId\": 103,\n" +
                "      \"discountType\": \"\",\n" +
                "      \"deadLine\": \"2016-05-30\"\n" +
                "    }\n" +
                "  ],\n" +
                "  \"userPhoneNo\": \"18000000000\",\n" +
                "  \"totalPrincipal\": 6000,\n" +
                "  \"fundingCorpName\": \"湖北消金\",\n" +
                "  \"userName\": \"测试\",\n" +
                "  \"userId\": 1001,\n" +
                "  \"loanCreateAt\": 1483945900051,\n" +
                "  \"loanHistoryId\": 3001,\n" +
                "  \"paymentCorpId\": 290,\n" +
                "  \"loanManifestHistoryId\": 2001,\n" +
                "  \"fundingCorpId\": 290,\n" +
                "  \"loanPaidAt\": 1483945900051,\n" +
                "  \"userIdNo\": \"100000000000000000\",\n" +
                "  \"contractTotalTerm\": 3\n" +
                "}";
        PaymentDetail paymentDetail = JSON.parseObject(json, PaymentDetail.class);
        System.out.println(JSON.toJSONString(paymentDetail));
        System.out.println(paymentDetail);
    }
}
