package cn.quantgroup.financial.util;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;

/**
 * Created by WuKong on 2017/1/17.
 */
public class FileUtil {

    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);

    public static BufferedInputStream getInputStream(String fileAddress) throws FileNotFoundException {
        File file = new File(fileAddress);
        if (file != null && file.exists()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            return in;
        } else {
            return null;
        }
    }

    public static BufferedReader getInputReaderStream(String fileAddress) throws FileNotFoundException, UnsupportedEncodingException {
        File file = new File(fileAddress);
        if (file != null && file.exists()) {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file), "UTF-8"));
            return in;
        } else {
            return null;
        }
    }

    public static String readFileFromUrl(String url) {
        return readFileFromUrl(url, false);
    }

    public static String readFileFromUrl(String fileUrl, boolean bom) {
        InputStream inputStream = null;
        try {
            URL url = new URL(fileUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setConnectTimeout(30 * 1000);
            connection.setRequestMethod("GET");
            connection.connect();

            int code = connection.getResponseCode();
            if (code != HttpURLConnection.HTTP_OK) {
                logger.error(">>> url {} response code is {} ! ", fileUrl, code);
                inputStream = connection.getErrorStream();
                String message = IOUtils.toString(inputStream, Charset.forName("UTF-8"));
                logger.error(">>> url {} response message is: {} ! ", fileUrl, message);
            } else {
                String message = null;
                inputStream = connection.getInputStream();
                if (bom) {
                    int length = inputStream.available();
                    byte[] bytes = new byte[length];
                    inputStream.read(bytes);
                    if (bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
                        byte[] newbytes = new byte[length - 3];
                        System.arraycopy(bytes, 3, newbytes, 0, length - 3);
                        bytes = newbytes;
                    }
                    message = new String(bytes);
                } else {
                    message = IOUtils.toString(inputStream,Charset.forName("UTF-8"));
                }

                if (StringUtils.isEmpty(message)) {
                    logger.error("No data found for url : {}", fileUrl);
                }

                return message;
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("error request url : {}", fileUrl);
            logger.error(e.getMessage(), e);
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    logger.error(e.getMessage(), e);
                    e.printStackTrace();
                }
            }
        }

        logger.error("No data found for url : {}", fileUrl);
        return null;
    }


    public static String parseFilePath(String filePath) {
        if (filePath == null)
            return null;
        char[] pathCharArray = filePath.toCharArray();
        StringBuffer pathBuffer = new StringBuffer();
        Character char1 = new Character('\\');
        Character char2 = new Character('/');

        for (int i = 0; i < pathCharArray.length; i++) {
            if (char1.equals(new Character(pathCharArray[i]))
                    || char2.equals(new Character(pathCharArray[i]))) {
                pathBuffer.append(File.separator);
            } else {
                pathBuffer.append(pathCharArray[i]);
            }
        }
        // filePath=filePath.replaceAll("/",File.separator);
        // filePath=filePath.replaceAll("\\",File.separator);
        return pathBuffer.toString();
    }

    /**
     * 处理小文件，直接转化为String内容，String如有中文会有问题
     *
     * @param fileName
     * @return
     * @bom 去除bom true 处理  false 不处理
     */
    public static String getSmallFile(String fileName, boolean bom) {
        fileName = parseFilePath(fileName);
        File DBFFile = new File(fileName);

        FileInputStream fileInput = null;
        try {

            fileInput = new FileInputStream(DBFFile);
            int length = fileInput.available();
            byte[] bytes = new byte[length];
            fileInput.read(bytes);
            if (bom) {
                if (bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
                    byte[] newbytes = new byte[length - 3];
                    System.arraycopy(bytes, 3, newbytes, 0, length - 3);
                    bytes = newbytes;
                }
            }

            return new String(bytes);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        } finally {
            if (fileInput != null) {
                try {
                    fileInput.close();
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        }
    }


    /**
     * 写文件
     *
     * @param message
     * @param path
     */
    public static void writeBytes(byte[] message, String path) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(path, true);
            os.write(message);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                os.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }


    /**
     * 递归构建目录
     *
     * @param path 目录路径
     * @return
     */
    public static void createDictory(String path) {

        File f = new File(path);
        File ft = f;
        while (!f.exists()) {
            ft = f;
            f = f.getParentFile();
        }
        if (f != ft) {
            ft.mkdir();
            createDictory(path);
        }
    }

}
