package cn.quantgroup.financial.service.thread.impl;

import cn.quantgroup.financial.service.thread.IApiScheduledExecutorService;
import org.springframework.stereotype.Service;

import java.util.concurrent.*;

/**
 * Created by WuKong on 2017/2/13.
 */
@Service
public class ApiScheduledExecutorServiceImpl implements IApiScheduledExecutorService {

    ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(15);

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return scheduledThreadPool.schedule(command,delay,unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return scheduledThreadPool.schedule(callable,delay,unit);
    }
}
