package cn.quantgroup.financial.scheduler;

import cn.quantgroup.financial.constant.HubeiCFCDataType;
import cn.quantgroup.financial.constant.HubeiCFCField;
import cn.quantgroup.financial.model.huibeicfc.HuBeiCFCResponse;
import cn.quantgroup.financial.service.IHuBeiService;
import cn.quantgroup.financial.service.sys.IScheduledJudgeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * 湖北每天的送盘文件每日定时任务
 * Created by WuKong on 2017/2/3.
 */
@Lazy(false)
@Component
public class HuBeiSendDiscScheduler {

    private static final Logger logger = LoggerFactory.getLogger(HuBeiSendDiscScheduler.class);
    @Autowired
    private IHuBeiService iHuBeiService;

    @Autowired
    private IScheduledJudgeService scheduledJudgeService;

    /**
     * Seconds Minutes Hours DayofMonth Month DayofWeek
     */
    @Scheduled(cron = "0 0 8 * * ?")
    public void dayScheduler(){
        if(scheduledJudgeService.isOpenScheduled()){
            try {
                logger.info("sendDisc HuBeiDayScheduler start ");
                //送盘文件
                HuBeiCFCResponse response = iHuBeiService.handleDiscData(HubeiCFCDataType.SEND_DEBIT,null,null,null);
                if(response!=null&& HubeiCFCField.EC_SUCCESS_CODE.equals(response.getEc())){
                    logger.info("get sendDisc response success");
                }else {
                    if(response==null){
                        iHuBeiService.sendErrorMailNotice("没有成功获取到送盘文件，响应为null");
                    }else {
                        iHuBeiService.sendErrorMailNotice("没有成功获取到送盘文件，错误码="+response.getEc()+"|错误信息="+response.getEm());
                    }
                    logger.info("response is null or don`t return result={}",response);
                }
            } catch (Exception e) {
                iHuBeiService.sendErrorMailNotice(e.getMessage());
                logger.error(e.getMessage(),e);
            }
        }
    }



}
