package cn.quantgroup.financial.json;


import com.fasterxml.jackson.annotation.JsonIgnore;

import cn.quantgroup.financial.util.ResultCode;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 
 * @author dave
 *
 */
public class JsonResponse implements Serializable{

    private static final long serialVersionUID = 2666283071500318636L;

    private boolean success = true;

    private ResultCode errCode = ResultCode.OK;

    private String errMsg = "";

    private Object data = null;

    public JsonResponse(ResultCode errCode, String errMsg) {
        this.success = false;
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public JsonResponse(ResultCode errCode){
        if(errCode != ResultCode.OK){
            this.success = false;
        }
        this.errCode = errCode;
        this.errMsg = errCode.getMsg();
    }

    public JsonResponse(){

    }

    public boolean isSuccess() {
        return success;
    }

    public JsonResponse setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public int getErrCode() {
        return errCode.getCode();
    }

    @JsonIgnore
    public ResultCode getErrCodeEnum(){
        return errCode;
    }

    public JsonResponse setErrCode(ResultCode errCode) {
        this.errCode = errCode;
        return this;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public JsonResponse setErrMsg(String errMsg) {
        this.errMsg = errMsg;
        return this;
    }

    public Object getData() {
        return data;
    }

    public JsonResponse setData(Object data) {
        this.data = data;
        return this;
    }

    public JsonResponse addData(String key, Object value) {
        if (this.data == null || !(this.data instanceof Map)) {
            this.data = new HashMap<String, Object>();
        }
        ((Map<String, Object>)this.data).put(key, value);
        return this;
    }

    public JsonResponse addAllData(Map<String, Object> data) {
        if (this.data == null || !(this.data instanceof Map)) {
            this.data = new HashMap<String, Object>();
        }
        ((Map<String, Object>)this.data).putAll(data);
        return this;
    }
}
