package cn.quantgroup.financial.handler.hubei.impl;

import cn.quantgroup.financial.constant.HubeiCFCDataType;
import cn.quantgroup.financial.handler.IHuBeiDispatcher;
import cn.quantgroup.financial.handler.hubei.HubeiContentHandler;
import cn.quantgroup.financial.model.huibeicfc.HuBeiHistory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by WuKong on 2017/1/19.
 */
@Service
public class HuBeiHandlerDispatcher implements IHuBeiDispatcher{

    private static final Logger logger = LoggerFactory.getLogger(HuBeiHandlerDispatcher.class);
    private static final Map<HubeiCFCDataType,HubeiContentHandler> handlerMap = new HashMap<HubeiCFCDataType,HubeiContentHandler>();

    @Autowired(required = false)
    public HuBeiHandlerDispatcher(List<HubeiContentHandler> handlers){
        if(handlers!=null){
            for (HubeiContentHandler handler: handlers){
                handlerMap.put(handler.getType(),handler);
            }
        }
    }

    @Override
    public HuBeiHistory parse(HubeiCFCDataType hubeiCFCDataType,String line){
        return handlerMap.get(hubeiCFCDataType).parse(line);
    }

    @Override
    public String builder(HubeiCFCDataType hubeiCFCDataType,HuBeiHistory huBeiHistory){
        try {
            return handlerMap.get(hubeiCFCDataType).builder(huBeiHistory);
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }
        return "";
    }
}
