package cn.quantgroup.financial.dao.impl;

import cn.quantgroup.financial.dao.ISystemDao;
import cn.quantgroup.financial.mapper.MailInfoMapper;
import cn.quantgroup.financial.model.MailInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * Created by WuKong on 2017/2/19.
 */
@Service
public class SystemDaoImpl implements ISystemDao {

    @Autowired
    MailInfoMapper mailInfoMapper;

    @Transactional(rollbackFor=Exception.class)
    @Override
    public Long saveMailInfo(MailInfo mailInfo){
        mailInfo.setCreatetime(new Date());
        mailInfo.setUpdatetime(new Date());
        mailInfoMapper.insert(mailInfo);
        return mailInfo.getId();
    }

    @Transactional(rollbackFor=Exception.class)
    @Override
    public Integer deleteMailInfo(Long mailId){
        return mailInfoMapper.deleteByPrimaryKey(mailId);
    }
}
