package cn.quantgroup.financial.controller;

import cn.quantgroup.financial.constant.CompensationStatus;
import cn.quantgroup.financial.constant.HubeiCFCDataType;
import cn.quantgroup.financial.exception.ArgsInvaildException;
import cn.quantgroup.financial.exception.FieldInsufficientException;
import cn.quantgroup.financial.json.JsonResult;
import cn.quantgroup.financial.mapper.PaymentDetailMapper;
import cn.quantgroup.financial.model.PaymentDetail;
import cn.quantgroup.financial.model.RepaymentPlanStatus;
import cn.quantgroup.financial.scheduler.HuBeiReturnDiscScheduler;
import cn.quantgroup.financial.scheduler.HuBeiSendDiscScheduler;
import cn.quantgroup.financial.service.IApiCommonService;
import cn.quantgroup.financial.service.IHuBeiService;
import cn.quantgroup.financial.util.MD5Util;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.*;

import static cn.quantgroup.financial.util.ResultCode.UNKNOW_RESULT;

/**
 * Created by WuKong on 2017/1/4.
 */
@Controller
@RequestMapping("/api")
public class ApiCommonController {

    private static final Logger logger = LoggerFactory.getLogger(ApiCommonController.class);

    @Autowired
    IApiCommonService iApiCommonService;

    @Autowired
    PaymentDetailMapper paymentDetailMapper;

    @Autowired
    IHuBeiService huBeiService;

    @Autowired
    HuBeiSendDiscScheduler huBeiDayScheduler;

    @Autowired
    HuBeiReturnDiscScheduler huBeiReturnDiscScheduler;

    /**
     * 放款 通知包含还款计划
     * @return
     */
    @RequestMapping(value = "/payment/notify", method = RequestMethod.POST)
    public  @ResponseBody JsonResult paymentNotify(@RequestBody PaymentDetail paymentDetail,@RequestHeader("macRandom") String macRandom,@RequestHeader("macValue") String macValue){
        try {
            logger.info("received message={},macRandom={}", JSON.toJSONString(paymentDetail),macRandom);
            String md5 = MD5Util.build("quantgroup_financial_api"+paymentDetail.getLoanHistoryId()+macRandom).toLowerCase();
            if(StringUtils.isEmpty(macValue)||!md5.equals(macValue.toLowerCase())){
                logger.info("macRandom={},macValue={}，md5={} is no authority",macRandom,macValue,md5);
                return JsonResult.NO_AUTHORITY();
            }
            iApiCommonService.savePaymentDetailAndRepaymentPlan(paymentDetail);
        } catch (FieldInsufficientException e) {
            logger.error(e.getMessage(),e);
            return JsonResult.ERROR_INSUFFICIENT(e.getMessage());
        }
        return JsonResult.SUCCESS();
    }

    /**
     * 查询还款计划状态是否代偿
     * @return
     */
    @RequestMapping(value = "/repayment/getPlansStatus", method = RequestMethod.POST)
    public @ResponseBody JsonResult getPlansStatus(@RequestBody RepaymentPlanStatus repaymentPlanStatus){
        List<RepaymentPlanStatus> repaymentPlanStatusList = null;

        try {
            logger.info("receive message={}",JSON.toJSONString(repaymentPlanStatus));
            repaymentPlanStatusList = iApiCommonService.getRepaymentPlanStatus(repaymentPlanStatus.getLoanHistoryId(),repaymentPlanStatus.getRepaymentPlanId());
            if(CollectionUtils.isEmpty(repaymentPlanStatusList)){
                iApiCommonService.queryData(repaymentPlanStatus.getLoanHistoryId(),null);
                repaymentPlanStatusList = iApiCommonService.getRepaymentPlanStatus(repaymentPlanStatus.getLoanHistoryId(),repaymentPlanStatus.getRepaymentPlanId());
            }
            if(CollectionUtils.isEmpty(repaymentPlanStatusList)){
                logger.info("query message={} result is empty",JSON.toJSONString(repaymentPlanStatus));
                return JsonResult.builder(UNKNOW_RESULT,null);
            }
        } catch (ArgsInvaildException e) {
            logger.error("receive message ={}",JSON.toJSONString(repaymentPlanStatus));
            logger.error(e.getMessage(),e);
            return JsonResult.ERROR_ARGS();
        }
        return JsonResult.SUCCESS(repaymentPlanStatusList);
    }

    @RequestMapping(value = "/repayment/repairData", method = {RequestMethod.POST,RequestMethod.GET})
    public @ResponseBody JsonResult repairOldData(@RequestBody List<Long> loanIdList){
        for(Long loanId: loanIdList){
            try {
                logger.info("repairOldData loanId={}",loanId);
                iApiCommonService.queryData(loanId,null);
            } catch (Exception e) {
                logger.error(e.getMessage(),e);
            }
        }
//        Date date = new Date();
//        Calendar calendar = Calendar.getInstance();
//        calendar.set(Calendar.DAY_OF_MONTH,27);
//        calendar.set(Calendar.MONTH,0);
//        calendar.set(Calendar.HOUR_OF_DAY,0);
//        calendar.set(Calendar.MINUTE,0);
//        calendar.set(Calendar.SECOND,0);
//        calendar.set(Calendar.MILLISECOND,0);
//        logger.info("update time={} "+calendar.getTime());
//        Integer row = iApiCommonService.updateBatchStatus(calendar.getTime(), CompensationStatus.already_status.get());
//
//        logger.info("repairOldData update row={}",row);
        return JsonResult.SUCCESS("success");

    }


    @RequestMapping(value = "/repayment/repairDataByIds", method = {RequestMethod.POST,RequestMethod.GET})
    public @ResponseBody JsonResult repairOldDataByIds(){
        List<Long> idList = new ArrayList<>(Arrays.asList(136026L,136030L,136036L,136042L,136048L,136054L,136060L));
        Integer row = iApiCommonService.updateBatchCompensationStatusById(idList,CompensationStatus.already_status.get());
        logger.info("repairOldData update row={}",row);
        return JsonResult.SUCCESS(row);

    }

    @RequestMapping(value = "/hubei/sendDisc", method = {RequestMethod.POST,RequestMethod.GET})
    public @ResponseBody JsonResult getSendDisc(@RequestParam("applyDt") String applyDt){
        try {
            huBeiService.handleDiscData(HubeiCFCDataType.SEND_DEBIT,null,null,new Integer(1).byteValue(),applyDt);
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }
        return JsonResult.SUCCESS();
    }


    @RequestMapping(value = "/hubei/checkDisc", method = {RequestMethod.POST,RequestMethod.GET})
    public @ResponseBody JsonResult checkDisc(@RequestParam("applyDt") String applyDt,@RequestParam("docName") String docName){
        try {
            huBeiService.handleDiscData(HubeiCFCDataType.SEND_ADVANCE_REPAYMENT_CHECK,docName,null,new Integer(1).byteValue(),applyDt);
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }
        return JsonResult.SUCCESS();
    }

    @RequestMapping(value = "/hubei/returnDiscScheduler", method = {RequestMethod.POST,RequestMethod.GET})
    public @ResponseBody JsonResult getReturnDisc(){
        try {
            huBeiReturnDiscScheduler.dayScheduler();
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return JsonResult.SUCCESS();
    }


    @RequestMapping(value = "/hubei/handleReturnDisc", method = {RequestMethod.POST,RequestMethod.GET})
    public @ResponseBody JsonResult handleReturnDisc(@RequestParam("applyDt") String applyDt,@RequestParam("type") Integer type,@RequestParam("docId") Long docId){
        try {
            if(type.intValue()==HubeiCFCDataType.RETURN_ADVANCE_REPAYMENT.get().intValue()){
//                huBeiService.handleDiscData(HubeiCFCDataType.RETURN_ADVANCE_REPAYMENT,null,docId,new Integer(1).byteValue(),applyDt);
            }else if(type.intValue()==HubeiCFCDataType.RETURN_BATCH_COMPENSATION.get().intValue()){
                huBeiService.handleDiscData(HubeiCFCDataType.RETURN_BATCH_COMPENSATION,null,docId,new Integer(1).byteValue(),applyDt);
            }else if(type.intValue()==HubeiCFCDataType.RETURN_BATCH_DEBIT.get().intValue()){
                huBeiService.handleDiscData(HubeiCFCDataType.RETURN_BATCH_DEBIT,null,docId,new Integer(1).byteValue(),applyDt);
            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return JsonResult.SUCCESS();
    }

}
