package cn.quantgroup.financial.model;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

/**
 * Created by wangbo on 2017/1/4.
 */
public class CompensationDayBean {

    private int year;
    private String[] compensationDays;

    private Set<String> compensationDaysSet;
    private Map<Integer,Date> compensationMonthMap;

    public int getYear() {
        return year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public String[] getCompensationDays() {
        return compensationDays;
    }

    public void setCompensationDays(String[] compensationDays) {
        this.compensationDays = compensationDays;
    }


    public void init() {
        this.compensationDaysSet = new HashSet<>(compensationDays.length);
        for (String day : compensationDays) {
            compensationDaysSet.add(getKeyofDay(day));
        }
        compensationMonthMap = new HashMap<>();
        for(String day : compensationDays){
            compensationMonthMap.put(Integer.valueOf(day.split("-")[0]),getDate(day));
        }
    }

    /**
     * 通过月查询代偿日时间
     * @param month 1-12
     * @return
     */
    public Date getCompensationDay(Integer month){
        return compensationMonthMap.get(month);
    }
    /**
     * 判断今天是否为代偿日
     * @return
     */
    public boolean isCompensationDay() {
        Calendar calendar = Calendar.getInstance();
        return isCompensationDay(calendar);
    }

    public boolean isCompensationDay(Calendar calendar) {
        if(CollectionUtils.isEmpty(compensationDaysSet)&&compensationDays!=null){
            init();
        }
        String keyofDay = getKeyofDay(calendar);
        if (compensationDaysSet.contains(keyofDay)) {
            return true;
        }
        return false;
    }

    private Date getDate(String dayStr){
        String[] args = dayStr.split("-");
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, Integer.valueOf(args[0])-1, Integer.valueOf(args[1]),0,0,0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTime();
    }
    private String getKeyofDay(String dayStr) {
        return "y" + year + "d" + StringUtils.remove(dayStr, "-");
    }

    private String getKeyofDay(Calendar calendar) {
        return "y" + year + "d" + (calendar.get(Calendar.MONTH) + 1) + calendar.get(Calendar.DAY_OF_MONTH);
    }
}
