package cn.quantgroup.financial.model.huibeicfc;

import cn.quantgroup.financial.constant.HubeiCFCDataType;

import java.io.Serializable;

/**
 * Created by WuKong on 2017/1/22. */
public class HuBeiCFCRequest implements Serializable {
    private String fileName;
    private String fileConent;
    //请求时间 格式yyyyMMdd
    private String applyDt;

    private HubeiCFCDataType hubeiCFCDataType;

    /**
     * 标识是否需要保存返回数据结果
     */
    private Boolean isSaveRepData;

    public static HuBeiCFCRequest build(HubeiCFCDataType hubeiCFCDataType,String fileName,String fileConent,String applyDt,Boolean isSaveRepData){
        return new HuBeiCFCRequest(fileName,fileConent,applyDt,hubeiCFCDataType,isSaveRepData);
    }

    public HuBeiCFCRequest(String fileName, String fileConent, String applyDt, HubeiCFCDataType hubeiCFCDataType, Boolean isSaveRepData) {
        this.fileName = fileName;
        this.fileConent = fileConent;
        this.applyDt = applyDt;
        this.hubeiCFCDataType = hubeiCFCDataType;
        this.isSaveRepData = isSaveRepData;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileConent() {
        return fileConent;
    }

    public void setFileConent(String fileConent) {
        this.fileConent = fileConent;
    }

    public HubeiCFCDataType getHubeiCFCDataType() {
        return hubeiCFCDataType;
    }

    public void setHubeiCFCDataType(HubeiCFCDataType hubeiCFCDataType) {
        this.hubeiCFCDataType = hubeiCFCDataType;
    }

    public Boolean getSaveRepData() {
        return isSaveRepData;
    }

    public void setSaveRepData(Boolean saveRepData) {
        isSaveRepData = saveRepData;
    }

    public String getApplyDt() {
        return applyDt;
    }

    public void setApplyDt(String applyDt) {
        this.applyDt = applyDt;
    }
}
