package cn.quantgroup.financial.aspect.data;

import cn.quantgroup.financial.constant.DataBaseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

/**
 * Created by WuKong on 2017/1/6.
 */
public class RoutingDataSourceProxy extends AbstractRoutingDataSource {
    private static final Logger logger = LoggerFactory.getLogger(RoutingDataSourceProxy.class);

    private static String systemDBName = DataBaseType.System_DB.get();
    private static String apiDBName = DataBaseType.Api_DB.get();

    /**
     * 决定使用哪个数据源
     * @return
     */
    @Override
    protected Object determineCurrentLookupKey() {
        if (DataSourceContextHolder.isSystemDB()) {
            logger.debug("using systemDBName !");
            return systemDBName;
        } else {
            logger.debug("using apiDBName !");
            return apiDBName;
        }
    }

    public void setSystemDBName(String systemDBName) {
        this.systemDBName = systemDBName;
    }

    public void setApiDBName(String apiDBName) {
        this.apiDBName = apiDBName;
    }
}
